/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.real.SpeedSign;

public class SpeedSignAnimation
extends Renderable2D {
    private double deltax;
    private double deltay;
    private Color backgroundColor;
    private Color textColor;
    private Color lineColor;

    public SpeedSignAnimation(SpeedSign owner, SimulatorInterface simulator) {
        this(owner, simulator, 0.0, 0.0, Color.BLACK, Color.YELLOW, Color.BLACK);
    }

    public SpeedSignAnimation(SpeedSign owner, SimulatorInterface simulator, double deltax, double deltay, Color backgroundColor, Color textColor, Color lineColor) {
        super((LocatableInterface)owner, simulator);
        this.deltax = deltax;
        this.deltay = -deltay;
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
        this.lineColor = lineColor;
    }

    public void paint(Graphics2D graphics, ImageObserver imo) throws RemoteException {
        SpeedSign sign = (SpeedSign)this.source;
        graphics.setColor(this.lineColor);
        graphics.setStroke(new BasicStroke(0.05f));
        graphics.draw(new Line2D.Double(0.0, 0.0, this.deltax, this.deltay));
        graphics.setColor(this.backgroundColor);
        graphics.fill(new Rectangle2D.Double(this.deltax - 3.0, this.deltay - 6.0, 6.0, 6.0));
        graphics.setColor(this.lineColor);
        graphics.draw(new Rectangle2D.Double(this.deltax - 3.0, this.deltay - 6.0, 6.0, 6.0));
        graphics.setColor(this.textColor);
        Font font = new Font("SansSerif", 0, 5);
        graphics.setFont(font);
        graphics.drawString(sign.getText(), (float)(this.deltax - 3.0), (float)(this.deltay - 1.0));
        graphics.setColor(Color.BLACK);
        Font smallFont = new Font("SansSerif", 0, 2);
        graphics.setFont(smallFont);
        graphics.drawString(this.source.toString(), (float)(this.deltax + 6.0), (float)this.deltay);
    }
}

