/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.controlpoint.blocks;

import java.rmi.RemoteException;
import java.util.List;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.animation.BlockTrafficLightAnimation;
import nl.tudelft.simulation.traffic.controlpoint.blocks.SingleTrackControlPoint;
import nl.tudelft.simulation.traffic.controlpoint.real.AbstractVisibleControlPoint;
import nl.tudelft.simulation.traffic.controlpoint.real.Changeable;
import nl.tudelft.simulation.traffic.controlpoint.real.StopSignInterface;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class SingleTrackBlockTrafficLight
extends AbstractVisibleControlPoint
implements LocatableInterface,
StopSignInterface {
    public static final String STATE_GREEN = "GREEN";
    public static final String STATE_YELLOW = "YELLOW";
    public static final String STATE_RED = "RED";
    public static final String STATE_BLACK = "BLACK";
    public static final int SENSOR_GREEN = 0;
    public static final int SENSOR_YELLOW = 1;
    public static final int SENSOR_RED = 2;
    public static final String[] sensorNames = new String[]{"GREEN", "YELLOW", "RED"};
    private double distanceRed;
    private double distanceYellow;
    private double distanceGreen;
    private String currentState = "GREEN";
    private String name;
    private double dx;
    private double dy;

    public SingleTrackBlockTrafficLight(String name, double progression, double visibleDistance, TrackInterface track, double distanceRed, double distanceYellow, double distanceGreen, DEVSSimulatorInterface simulator, double dx, double dy) throws Exception {
        super(track, progression, visibleDistance, (SimulatorInterface)simulator);
        this.name = name;
        System.out.println(this + ", placed on " + track + " progression " + progression + " (length=" + track.getLength() + ")");
        this.distanceRed = distanceRed;
        this.distanceYellow = distanceYellow;
        this.distanceGreen = distanceGreen;
        this.addSensors(this.track, progression + this.distanceRed, 2, (SimulatorInterface)simulator);
        this.addSensors(this.track, progression + this.distanceYellow, 1, (SimulatorInterface)simulator);
        this.addSensors(this.track, progression + this.distanceGreen, 0, (SimulatorInterface)simulator);
        this.dx = dx;
        this.dy = dy;
        if (simulator instanceof AnimatorInterface) {
            new BlockTrafficLightAnimation(this, (SimulatorInterface)simulator, dx, dy);
        }
    }

    private void addSensors(TrackInterface track, double place, int sensor, SimulatorInterface simulator) throws Exception {
        List tpList = track.calculateTrackProgressionListAll(place);
        int i = 0;
        while (i < tpList.size()) {
            TrackProgression tp = (TrackProgression)tpList.get(i);
            new SingleTrackControlPoint(tp.getTrack(), tp.getProgression(), this, sensor, simulator);
            System.out.println(this + ", sensor " + sensorNames[sensor] + " added on track " + tp.getTrack() + ", progression " + tp.getProgression());
            ++i;
        }
    }

    public void triggerSensor(int sensor, VehiclePhysicalInterface vehicle) {
        Logger.fine((Object)this, (String)"triggerSensor", (String)(this + ", Vehicle " + vehicle.toString() + " triggered sensor " + sensorNames[sensor] + ", old state was " + this.currentState));
        System.out.println(this + ", Vehicle " + vehicle.toString() + " triggered sensor " + sensorNames[sensor] + ", old state was " + this.currentState);
        if (this.currentState == STATE_BLACK) {
            this.currentState = STATE_BLACK;
        } else if (this.currentState == STATE_RED) {
            switch (sensor) {
                case 2: {
                    this.currentState = STATE_BLACK;
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"RED - RED");
                    break;
                }
                case 1: {
                    this.currentState = STATE_YELLOW;
                    break;
                }
                case 0: {
                    this.currentState = STATE_RED;
                    break;
                }
                default: {
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"reported state not RED, YELLOW or GREEN");
                    break;
                }
            }
        } else if (this.currentState == STATE_YELLOW) {
            switch (sensor) {
                case 2: {
                    this.currentState = STATE_RED;
                    break;
                }
                case 1: {
                    this.currentState = STATE_BLACK;
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"YELLOW - YELLOW");
                    break;
                }
                case 0: {
                    this.currentState = STATE_GREEN;
                    break;
                }
                default: {
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"reported state not RED, YELLOW or GREEN");
                    break;
                }
            }
        } else if (this.currentState == STATE_GREEN) {
            switch (sensor) {
                case 2: {
                    this.currentState = STATE_RED;
                    break;
                }
                case 1: {
                    this.currentState = STATE_BLACK;
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"GREEN - YELLOW");
                    break;
                }
                case 0: {
                    this.currentState = STATE_BLACK;
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"GREEN - GREEN");
                    break;
                }
                default: {
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"reported state not RED, YELLOW or GREEN");
                    break;
                }
            }
        } else {
            Logger.severe((Object)this, (String)"triggerSensor", (String)"SingleTrackBlockTrafficLight not in state RED, YELLOW or GREEN");
        }
        Logger.fine((Object)this, (String)"triggerSensor", (String)(this + ", Vehicle " + vehicle.toString() + " new state is " + this.currentState));
        System.out.println(this + ", Vehicle " + vehicle.toString() + " new state is " + this.currentState);
        Event event = new Event(Changeable.CHANGE_STATUS_EVENT, (Object)this, null);
        this.fireEvent((EventInterface)event);
    }

    public void pass(VehiclePhysicalInterface vehicle) {
        this.removeListener(vehicle, Changeable.CHANGE_STATUS_EVENT);
    }

    public DirectedPoint getLocation() throws RemoteException {
        DirectedPoint p = super.getTrack().getLocationOfProgression(super.getProgression());
        return new DirectedPoint(p.x, p.y, p.z);
    }

    public Bounds getBounds() throws RemoteException {
        return new BoundingBox(new Point3d(this.dx - 2.0, this.dy, 0.0), new Point3d(this.dx + 2.0, this.dy + 12.0, 0.0));
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public String getStatus() {
        if (this.currentState == STATE_RED || this.currentState == STATE_BLACK) {
            return "STOP";
        }
        return "CONT";
    }

    public String toString() {
        return "SingleBlockTrafficLight " + this.name;
    }
}

