/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.controlpoint.blocks;

import java.rmi.RemoteException;
import java.util.List;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.animation.SwitchBlockTrafficLightAnimation;
import nl.tudelft.simulation.traffic.controlpoint.blocks.SwitchBlockControlPoint;
import nl.tudelft.simulation.traffic.controlpoint.blocks.VirtualBlock;
import nl.tudelft.simulation.traffic.controlpoint.real.AbstractVisibleControlPoint;
import nl.tudelft.simulation.traffic.controlpoint.real.Changeable;
import nl.tudelft.simulation.traffic.controlpoint.real.StopSignInterface;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class SwitchBlockTrafficLight
extends AbstractVisibleControlPoint
implements LocatableInterface,
StopSignInterface {
    public static final String STATE_GREEN = "GREEN";
    public static final String STATE_RED = "RED";
    public static final String STATE_BLACK = "BLACK";
    public static final int SENSOR_REQUEST = 0;
    public static final int SENSOR_RED = 1;
    public static final int SENSOR_RELEASE = 2;
    public static final String[] sensorNames = new String[]{"REQUEST", "RED", "RELEASE"};
    private double distanceRequest;
    private double distanceRed;
    private double distanceRelease;
    private String currentState = "RED";
    private String name;
    private double dx;
    private double dy;
    private VirtualBlock virtualBlock;
    private VehiclePhysicalInterface requestingVehicle;

    public SwitchBlockTrafficLight(String name, TrackInterface track, double progression, VirtualBlock virtualBlock, double visibleDistance, double distanceRequest, double distanceRed, DEVSSimulatorInterface simulator, double dx, double dy) {
        super(track, progression, visibleDistance, (SimulatorInterface)simulator);
        this.name = name;
        System.out.println(this + ", placed on " + track + " progression " + progression + " (length=" + track.getLength() + ")");
        this.virtualBlock = virtualBlock;
        this.distanceRed = distanceRed;
        this.distanceRequest = distanceRequest;
        double vcpProg = distanceRequest - progression;
        this.buildRequestControlPoints(track, vcpProg, simulator);
        this.addSensors(this.track, progression + this.distanceRed, 1, simulator);
        this.dx = dx;
        this.dy = dy;
        if (simulator instanceof AnimatorInterface) {
            new SwitchBlockTrafficLightAnimation(this, (SimulatorInterface)simulator, dx, dy);
        }
    }

    private void addSensors(TrackInterface track, double progression, int sensor, DEVSSimulatorInterface simulator) {
        List tpList = track.calculateTrackProgressionListAll(progression);
        int i = 0;
        while (i < tpList.size()) {
            TrackProgression tp = (TrackProgression)tpList.get(i);
            new SwitchBlockControlPoint(tp.getTrack(), tp.getProgression(), this, sensor, (SimulatorInterface)simulator);
            System.out.println(this + ", sensor " + sensorNames[sensor] + " added on track " + tp.getTrack() + ", progression " + tp.getProgression());
            ++i;
        }
    }

    public void addSensors(TrackInterface track, double progression, int sensor, String line, DEVSSimulatorInterface simulator) {
        List tpList = track.calculateTrackProgressionListLine(progression, line);
        int i = 0;
        while (i < tpList.size()) {
            TrackProgression tp = (TrackProgression)tpList.get(i);
            new SwitchBlockControlPoint(tp.getTrack(), tp.getProgression(), this, sensor, (SimulatorInterface)simulator);
            System.out.println(this + ", sensor " + sensorNames[sensor] + " added on track " + tp.getTrack() + ", progression " + tp.getProgression());
            ++i;
        }
    }

    private void buildRequestControlPoints(TrackInterface track, double vcpProg, DEVSSimulatorInterface simulator) {
        List tpList = track.calculateTrackProgressionListAll(-vcpProg);
        int i = 0;
        while (i < tpList.size()) {
            TrackProgression tp = (TrackProgression)tpList.get(i);
            new SwitchBlockControlPoint(tp.getTrack(), tp.getProgression(), this, 0, (SimulatorInterface)simulator);
            System.out.println(this + ", sensor " + sensorNames[0] + " added on track " + tp.getTrack() + ", progression " + tp.getProgression());
            ++i;
        }
    }

    public void triggerSensor(int sensor, VehiclePhysicalInterface vehicle) {
        Logger.fine((Object)this, (String)"triggerSensor", (String)(this + ", Vehicle " + vehicle.toString() + " triggered sensor " + sensorNames[sensor] + ", old state was " + this.currentState));
        System.out.println(this + ", Vehicle " + vehicle.toString() + " triggered sensor " + sensorNames[sensor] + ", old state was " + this.currentState);
        if (this.currentState == STATE_BLACK) {
            this.changeState(STATE_BLACK);
        } else if (this.currentState == STATE_RED) {
            switch (sensor) {
                case 0: {
                    this.requestingVehicle = vehicle;
                    this.virtualBlock.requestAccess(this);
                    break;
                }
                case 1: {
                    this.changeState(STATE_BLACK);
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"RED - RED");
                    break;
                }
                case 2: {
                    this.virtualBlock.releaseBlock();
                    break;
                }
                default: {
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"sensor not RED, REQUEST or RELEASE");
                    break;
                }
            }
        } else if (this.currentState == STATE_GREEN) {
            switch (sensor) {
                case 0: {
                    this.changeState(STATE_BLACK);
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"GREEN - REQUEST");
                    break;
                }
                case 1: {
                    this.changeState(STATE_RED);
                    break;
                }
                case 2: {
                    this.changeState(STATE_BLACK);
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"GREEN - RELEASE");
                    break;
                }
                default: {
                    Logger.severe((Object)this, (String)"triggerSensor", (String)"sensor not RED, REQUEST or RELEASE");
                    break;
                }
            }
        } else {
            Logger.severe((Object)this, (String)"triggerSensor", (String)"SwitchBlockTrafficLight not in state BLACK, RED or GREEN");
        }
        Logger.fine((Object)this, (String)"triggerSensor", (String)(this + ", Vehicle " + vehicle.toString() + " new state is " + this.currentState));
        System.out.println(this + ", Vehicle " + vehicle.toString() + " new state is " + this.currentState);
    }

    protected void changeState(String newState) {
        this.currentState = newState;
        Event event = new Event(Changeable.CHANGE_STATUS_EVENT, (Object)this, null);
        this.fireEvent((EventInterface)event);
    }

    public void pass(VehiclePhysicalInterface vehicle) {
        this.removeListener(vehicle, Changeable.CHANGE_STATUS_EVENT);
    }

    public DirectedPoint getLocation() throws RemoteException {
        DirectedPoint p = super.getTrack().getLocationOfProgression(super.getProgression());
        return new DirectedPoint(p.x, p.y, p.z);
    }

    public Bounds getBounds() throws RemoteException {
        return new BoundingBox(new Point3d(this.dx - 2.0, this.dy, 0.0), new Point3d(this.dx + 2.0, this.dy + 12.0, 0.0));
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(String state) {
        this.currentState = state;
    }

    public String getStatus() {
        if (this.currentState == STATE_RED || this.currentState == STATE_BLACK) {
            return "STOP";
        }
        return "CONT";
    }

    public String toString() {
        return "SwitchBlockTrafficLight " + this.name;
    }

    public VirtualBlock getVirtualBlock() {
        return this.virtualBlock;
    }

    public double getDistanceRed() {
        return this.distanceRed;
    }

    public double getDistanceRelease() {
        return this.distanceRelease;
    }

    public void setDistanceRelease(double distanceRelease) {
        this.distanceRelease = distanceRelease;
    }

    public double getDistanceRequest() {
        return this.distanceRequest;
    }

    public String getName() {
        return this.name;
    }

    public VehiclePhysicalInterface getRequestingVehicle() {
        return this.requestingVehicle;
    }

    public void setRequestingVehicle(VehiclePhysicalInterface requestingVehicle) {
        this.requestingVehicle = requestingVehicle;
    }
}

