/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.controlpoint.real;

import java.awt.Color;
import java.rmi.RemoteException;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.SpeedSignAnimation;
import nl.tudelft.simulation.traffic.controlpoint.real.AbstractVisibleControlPoint;
import nl.tudelft.simulation.traffic.controlpoint.real.SpeedLimitInterface;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class SpeedSign
extends AbstractVisibleControlPoint
implements SpeedLimitInterface,
LocatableInterface {
    private double speedLimit;
    private String name;
    private double dx;
    private double dy;
    private String text;

    public SpeedSign(String name, TrackInterface track, double progression, double visibleDistance, double speedLimit, SimulatorInterface simulator, double dx, double dy, String text, Color backgroundColor, Color textColor, Color lineColor) {
        super(track, progression, visibleDistance, simulator);
        this.name = name;
        System.out.println(this + ", placed on " + track + " progression " + progression + " (length=" + track.getLength() + ")");
        this.speedLimit = speedLimit;
        this.dx = dx;
        this.dy = dy;
        this.text = text;
        if (simulator instanceof AnimatorInterface) {
            new SpeedSignAnimation(this, simulator, dx, dy, backgroundColor, textColor, lineColor);
        }
    }

    public void pass(VehiclePhysicalInterface vehicle) {
        vehicle.setMaximumSpeed(this.speedLimit);
    }

    public double getProgression() {
        return super.getProgression();
    }

    public TrackInterface getTrack() {
        return super.getTrack();
    }

    public double getSpeedLimit() {
        return this.speedLimit;
    }

    public DirectedPoint getLocation() throws RemoteException {
        DirectedPoint p = super.getTrack().getLocationOfProgression(super.getProgression());
        return new DirectedPoint(p.x, p.y, p.z);
    }

    public Bounds getBounds() throws RemoteException {
        return new BoundingBox(new Point3d(this.dx - 3.0, this.dy, 0.0), new Point3d(this.dx + 3.0, this.dy + 6.0, 0.0));
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "Speedsign " + this.name;
    }
}

