/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.controlpoint.virtual;

import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.ControlPointAnimation;
import nl.tudelft.simulation.traffic.controlpoint.virtual.VirtualControlPointInterface;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;

public abstract class VirtualControlPoint
extends EventProducer
implements VirtualControlPointInterface {
    private double progression;
    private TrackInterface track;
    private DirectedPoint location;

    public VirtualControlPoint(TrackInterface track, double progression, SimulatorInterface simulator) {
        TrackProgression tp = track.calculateTrackProgressionListActive(progression);
        this.track = tp.getTrack();
        this.progression = tp.getProgression();
        this.location = this.track.getLocationOfProgression(this.progression);
        this.location.setRotZ(0.0);
        this.track.addControlPoint(this);
        if (simulator instanceof AnimatorInterface) {
            new ControlPointAnimation(this, simulator);
        }
    }

    public double getProgression() {
        return this.progression;
    }

    public TrackInterface getTrack() {
        return this.track;
    }

    public Bounds getBounds() throws RemoteException {
        return new BoundingBox(new Point3d(-0.1, -0.1, 0.0), new Point3d(0.1, 0.1, 0.0));
    }

    public DirectedPoint getLocation() throws RemoteException {
        return this.location;
    }
}

