/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.track;

import java.awt.geom.Point2D;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.language.d2.Angle;
import nl.tudelft.simulation.language.d2.Circle;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.track.Track;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;

public class ArcTrack
extends Track {
    private double length;
    double theta = Math.atan2(super.getdy(), super.getdx());
    private double radius;
    private Point2D center;
    private double startAngle;
    private double endAngle;
    private double deltaAngle;
    private boolean counterClockwise;

    public ArcTrack(String name, TrackLinkInterface startLink, TrackLinkInterface endLink, double radius) throws Exception {
        super(name, startLink, endLink);
        this.radius = Math.abs(radius);
        Point2D.Double start = new Point2D.Double(startLink.getPosition().x, startLink.getPosition().y);
        Point2D.Double end = new Point2D.Double(endLink.getPosition().x, endLink.getPosition().y);
        Point2D[] intersection = Circle.intersection((Point2D)start, (double)this.radius, (Point2D)end, (double)this.radius);
        if (intersection.length < 2) {
            throw new Exception("ArcTrack " + name + " - points too far apart for radius");
        }
        this.counterClockwise = radius < 0.0;
        this.center = this.counterClockwise ? intersection[1] : intersection[0];
        this.startAngle = Angle.normalize2Pi((double)Angle.angle((Point2D)this.center, (Point2D)start));
        this.endAngle = Angle.normalize2Pi((double)Angle.angle((Point2D)this.center, (Point2D)end));
        if (this.counterClockwise) {
            this.deltaAngle = Angle.normalize2Pi((double)(this.endAngle - this.startAngle));
            this.length = this.radius * Angle.normalize2Pi((double)(this.endAngle - this.startAngle));
        } else {
            this.deltaAngle = -Angle.normalize2Pi((double)(this.startAngle - this.endAngle));
            this.length = this.radius * Angle.normalize2Pi((double)(this.startAngle - this.endAngle));
        }
        Logger.finest((Object)this, (String)"ArcTrack", (String)("from:" + ((Point2D)start).getX() + "," + ((Point2D)start).getY() + "  to:" + ((Point2D)end).getX() + "," + ((Point2D)end).getY() + " - length=" + this.length + "  [as,ae=" + this.startAngle + "," + this.endAngle + "]" + "delta-a=" + this.deltaAngle));
    }

    public DirectedPoint getLocationOfProgression(double progression) {
        Point3d startPoint = this.startLink.getPosition();
        Point3d endPoint = this.endLink.getPosition();
        double delta = progression / this.length;
        double angle = Angle.normalize2Pi((double)(this.startAngle + delta * this.deltaAngle));
        double x = this.center.getX() + this.radius * Math.cos(angle);
        double y = this.center.getY() + this.radius * Math.sin(angle);
        double z = startPoint.z + delta * (endPoint.z - startPoint.z);
        return new DirectedPoint(x, y, z, 0.0, 0.0, 0.0);
    }

    public Bounds getBounds() {
        Point3d p = this.startLink.getPosition();
        Point3d q = this.endLink.getPosition();
        return new BoundingBox(new Point3d(0.0, 0.0, 0.0), new Point3d(q.x - p.x, q.y - p.y, q.z - p.z));
    }

    public double getRadius() {
        return this.radius;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public boolean isCounterClockwise() {
        return this.counterClockwise;
    }

    public double getLength() {
        return this.length;
    }
}

