/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.track;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;
import nl.tudelft.simulation.traffic.track.util.TrackList;

public class ComplexTrackLink
extends DirectedPoint
implements TrackLinkInterface {
    private String name;
    private TrackList predecessors = new TrackList();
    private TrackList successors = new TrackList();
    private TrackInterface activePredecessor;
    private TrackInterface activeSuccessor;

    public ComplexTrackLink(String name, DirectedPoint location) {
        super(location);
        this.name = name;
    }

    public ComplexTrackLink(String name, Point3d point) {
        super(point);
        this.name = name;
    }

    public ComplexTrackLink(String name, double x, double y, double z) {
        super(x, y, z);
        this.name = name;
    }

    public void addSuccessor(TrackInterface successor) {
        this.successors.add(successor);
    }

    public void addPredecessor(TrackInterface predecessor) {
        this.predecessors.add(predecessor);
    }

    public void setActiveSuccessor(TrackInterface prevTrack, TrackInterface nextTrack) {
        if (!this.predecessors.contains(prevTrack)) {
            Logger.warning((Object)this, (String)"setActiveSuccessor", (String)("Predecessor " + prevTrack + " for " + this.name + " not in list of predecessor"));
        }
        if (!this.successors.contains(nextTrack)) {
            Logger.warning((Object)this, (String)"setActiveSuccessor", (String)("Active successor " + nextTrack + " for " + this.name + " not in list of successors"));
        }
        this.activeSuccessor = nextTrack;
        this.setActivePredecessor(nextTrack, prevTrack);
        System.out.println("Sucessor changed successfully to:  " + nextTrack.toString());
    }

    protected void setActivePredecessor(TrackInterface successor, TrackInterface predecessor) {
        if (!this.predecessors.contains(predecessor)) {
            Logger.warning((Object)this, (String)"setActivePredecessor", (String)("Predecessor " + predecessor + " for " + successor + " not in list of predecessor"));
        }
        if (!this.successors.contains(successor)) {
            Logger.warning((Object)this, (String)"setActivePredecessor", (String)("Active Successor " + successor + " for " + predecessor + " not in list of successors"));
        }
        this.activePredecessor = successor;
        System.out.println("Predecessor changed successfully to: " + predecessor.toString());
    }

    public TrackInterface getActiveSuccessor(TrackInterface predecessor) {
        if (!this.predecessors.contains(predecessor)) {
            Logger.warning((Object)this, (String)"getActiveSuccessor", (String)("Predecessor " + predecessor + " for " + this.name + " not in list of predecessor"));
        }
        return this.activeSuccessor;
    }

    public TrackInterface getActivePredecessor(TrackInterface successor) {
        if (!this.successors.contains(successor)) {
            Logger.warning((Object)this, (String)"getActivePredecessor", (String)("Successor " + successor + " for " + this.name + " not in list of predecessor"));
        }
        return this.activePredecessor;
    }

    public TrackList getSuccessors() {
        return this.successors;
    }

    public TrackList getPredecessors() {
        return this.predecessors;
    }

    public Point3d getPosition() {
        return this;
    }

    public Bounds getBounds() {
        return new BoundingSphere((Point3d)this, 1.0);
    }

    public DirectedPoint getLocation() {
        return this;
    }

    public String toString() {
        return this.name;
    }
}

