/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.track;

import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.track.Track;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;

public class StraightTrack
extends Track {
    private double theta = 0.0;
    private double length;

    public StraightTrack(String name, TrackLinkInterface startLink, TrackLinkInterface endLink) {
        super(name, startLink, endLink);
        try {
            this.length = this.startLink.getLocation().distance((Point3d)this.endLink.getLocation());
        }
        catch (RemoteException exception) {
            exception.printStackTrace();
        }
        this.theta = Math.atan2(super.getdy(), super.getdx());
    }

    public DirectedPoint getLocationOfProgression(double progression) {
        double delta = progression / this.length;
        Point3d startPoint = this.startLink.getPosition();
        Point3d endPoint = this.endLink.getPosition();
        double x = startPoint.x + delta * (endPoint.x - startPoint.x);
        double y = startPoint.y + delta * (endPoint.y - startPoint.y);
        double z = startPoint.z + delta * (endPoint.z - startPoint.z);
        return new DirectedPoint(x, y, z, 0.0, 0.0, this.theta);
    }

    public Bounds getBounds() {
        Point3d p = this.startLink.getPosition();
        Point3d q = this.endLink.getPosition();
        return new BoundingBox(new Point3d(0.0, 0.0, 0.0), new Point3d(q.x - p.x, q.y - p.y, q.z - p.z));
    }

    public double getLength() {
        return this.length;
    }
}

