/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.track;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface;
import nl.tudelft.simulation.traffic.controlpoint.util.ControlPointsList;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;
import nl.tudelft.simulation.traffic.track.util.TrackList;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public abstract class Track
implements TrackInterface,
LocatableInterface {
    protected String name;
    protected TrackLinkInterface startLink;
    protected TrackLinkInterface endLink;
    private ControlPointsList controlPoints;
    protected List vehicles = new ArrayList();
    protected static final int TRACK_ROUTE_ALL = 0;
    protected static final int TRACK_ROUTE_ACTIVE = 1;
    protected static final int TRACK_ROUTE_LINE = 2;

    public Track(String name, TrackLinkInterface startLink, TrackLinkInterface endLink) {
        this.name = name;
        this.controlPoints = new ControlPointsList();
        this.startLink = startLink;
        this.endLink = endLink;
        startLink.addSuccessor(this);
        endLink.addPredecessor(this);
    }

    public TrackLinkInterface getStartLink() {
        return this.startLink;
    }

    public TrackLinkInterface getEndLink() {
        return this.endLink;
    }

    public ControlPointsList getControlPoints() {
        return this.controlPoints;
    }

    public void addControlPoint(ControlPointInterface cp) {
        this.controlPoints.add(cp);
    }

    public ControlPointsList getCpsOnInterval(double progression, double lengthOfInterval) {
        ControlPointsList list = new ControlPointsList();
        Iterator it = this.controlPoints.iterator();
        while (it.hasNext()) {
            ControlPointInterface cp = (ControlPointInterface)it.next();
            double cpProg = cp.getProgression();
            if (!(cpProg >= progression) || !(cpProg <= progression + lengthOfInterval)) continue;
            list.add(cp);
        }
        return list;
    }

    public double getdx() {
        return this.endLink.getPosition().x - this.startLink.getPosition().x;
    }

    public double getdy() {
        return this.endLink.getPosition().y - this.startLink.getPosition().y;
    }

    public DirectedPoint getLocation() throws RemoteException {
        return (DirectedPoint)this.startLink;
    }

    public void removeControlPoint(ControlPointInterface cp) {
        this.controlPoints.remove(cp);
    }

    public String toString() {
        return this.name;
    }

    public void addVehicle(VehiclePhysicalInterface vehicle) {
        if (this.vehicles.contains(vehicle)) {
            Logger.warning((Object)this, (String)"addVehicle", (String)"vehicle already on track");
        }
        this.vehicles.add(vehicle);
    }

    public void removeVehicle(VehiclePhysicalInterface vehicle) {
        if (!this.vehicles.contains(vehicle)) {
            Logger.warning((Object)this, (String)"removeVehicle", (String)("vehicle not on track " + this));
        } else if (this.vehicles.indexOf(vehicle) != 0) {
            Logger.warning((Object)this, (String)"removeVehicle", (String)("vehicle not first on track " + this));
        } else {
            this.vehicles.remove(vehicle);
        }
    }

    public List getVehiclesOnTrack() {
        return this.vehicles;
    }

    public List calculateTrackProgressionListAll(double delta) {
        ArrayList<TrackProgression> trackProgressionList = new ArrayList<TrackProgression>();
        if (delta == 0.0) {
            trackProgressionList.add(new TrackProgression(this, 0.0));
        } else if (delta > 0.0) {
            this.calculateTrackProgressionListForward(this, delta, 0, trackProgressionList, null);
        } else {
            this.calculateTrackProgressionListBackward(this, delta, 0, trackProgressionList, null);
        }
        if (trackProgressionList.size() == 0) {
            System.out.println(this + ", trackProgressionList.size() = 0. Track = " + this + ", delta = " + delta);
        }
        return trackProgressionList;
    }

    public TrackProgression calculateTrackProgressionListActive(double delta) {
        ArrayList<TrackProgression> trackProgressionList = new ArrayList<TrackProgression>();
        if (delta == 0.0) {
            trackProgressionList.add(new TrackProgression(this, 0.0));
        } else if (delta > 0.0) {
            this.calculateTrackProgressionListForward(this, delta, 1, trackProgressionList, null);
        } else {
            this.calculateTrackProgressionListBackward(this, delta, 1, trackProgressionList, null);
        }
        if (trackProgressionList.size() != 1) {
            System.out.println("ERROR, calculateTrackProgressionListActive. trackProgressionList.size() != 1 (" + trackProgressionList.size() + "). Track = " + this + ", delta = " + delta);
            if (trackProgressionList.size() > 1) {
                return (TrackProgression)trackProgressionList.get(0);
            }
            return null;
        }
        return (TrackProgression)trackProgressionList.get(0);
    }

    public List calculateTrackProgressionListLine(double delta, String line) {
        ArrayList<TrackProgression> trackProgressionList = new ArrayList<TrackProgression>();
        if (delta == 0.0) {
            trackProgressionList.add(new TrackProgression(this, 0.0));
        } else if (delta > 0.0) {
            this.calculateTrackProgressionListForward(this, delta, 2, trackProgressionList, line);
        } else {
            Logger.warning((Object)this, (String)"calculateTrackProgressionListLine", (String)"Negative delta cannot be calculated for line path");
        }
        return trackProgressionList;
    }

    private void calculateTrackProgressionListForward(TrackInterface track, double delta, int routeType, List trackProgressionList, String line) {
        double length = track.getLength();
        if (delta < length) {
            TrackProgression tp = new TrackProgression(track, delta);
            trackProgressionList.add(tp);
            return;
        }
        TrackLinkInterface link = track.getEndLink();
        switch (routeType) {
            case 0: {
                TrackList tl = link.getSuccessors();
                int i = 0;
                while (i < tl.size()) {
                    TrackInterface nextTrack = tl.get(i);
                    if (nextTrack == null) {
                        System.err.println("TRACK " + track + ", LINK " + link + " does not have successors");
                        return;
                    }
                    this.calculateTrackProgressionListForward(nextTrack, delta - length, routeType, trackProgressionList, line);
                    ++i;
                }
                break;
            }
            case 1: {
                TrackInterface nextTrack = link.getActiveSuccessor(track);
                if (nextTrack == null) {
                    System.err.println("TRACK " + track + ", LINK " + link + " does not have successors");
                    return;
                }
                this.calculateTrackProgressionListForward(nextTrack, delta - length, routeType, trackProgressionList, line);
                break;
            }
            case 2: {
                Logger.warning((Object)this, (String)"calculateTrackProgressionListForward", (String)"Progression per line cannot be calculated yet");
                break;
            }
            default: {
                Logger.warning((Object)this, (String)"calculateTrackProgressionListForward", (String)("parameter 'all' does not have the right value: " + routeType));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void calculateTrackProgressionListBackward(TrackInterface track, double delta, int routeType, List trackProgressionList, String line) {
        block12: {
            block11: {
                length = track.getLength();
                if (delta > length) {
                    Logger.warning((Object)this, (String)"calculateTrackProgressionListBackward", (String)"delta larger than track length");
                    System.out.println("calculateTrackProgressionListBackward: delta " + delta + " larger than track " + track + ".length " + length);
                    return;
                }
                if (delta >= 0.0) {
                    tp = new TrackProgression(track, delta);
                    trackProgressionList.add(tp);
                    return;
                }
                link = track.getStartLink();
                if (routeType != 0) break block11;
                tl = link.getPredecessors();
                i = 0;
                while (i < tl.size()) {
                    prevTrack = tl.get(i);
                    this.calculateTrackProgressionListBackward(prevTrack, delta + prevTrack.getLength(), routeType, trackProgressionList, line);
                    ++i;
                }
                break block12;
            }
            if (routeType != 1) ** GOTO lbl43
            tl = link.getPredecessors();
            if (tl.size() == 1) {
                prevTrack = tl.get(0);
                if (prevTrack == null) {
                    Logger.warning((Object)this, (String)"calculateTrackProgressionListBackward", (String)"prevTrack = null");
                    System.out.println("calculateTrackProgressionListBackward: prevTrack = null for Track " + track);
                } else {
                    this.calculateTrackProgressionListBackward(prevTrack, delta + prevTrack.getLength(), routeType, trackProgressionList, line);
                }
            } else if (tl.size() > 1) {
                i = 0;
                while (i < tl.size()) {
                    prevTrack = tl.get(i);
                    if (track.equals(prevTrack.getEndLink().getActiveSuccessor(prevTrack))) {
                        this.calculateTrackProgressionListBackward(prevTrack, delta + prevTrack.getLength(), routeType, trackProgressionList, line);
                    }
                    ++i;
                }
            } else {
                System.out.println("ERROR calculateTrackProgressionListBackward: No predecessors for link " + link);
                return;
lbl43:
                // 1 sources

                Logger.warning((Object)this, (String)"calculateTrackProgressionListBackward", (String)("parameter 'all' does not have the right value: " + routeType));
                return;
            }
        }
    }

    public static double calculateDistanceFrontBack(VehiclePhysicalInterface vehicle0, VehiclePhysicalInterface vehicle1) {
        System.out.println("------------------------------------- calculateDistanceFrontBack " + vehicle0 + "-" + vehicle1);
        double maxDistance = 250.0;
        TrackProgression tp0 = new TrackProgression(vehicle0.getCurrentTrack(), vehicle0.getProgression());
        System.out.println("tp0 = " + tp0.getTrack() + ":" + tp0.getProgression());
        TrackProgression tp1 = vehicle1.getCurrentTrack().calculateTrackProgressionListActive(vehicle1.getProgression() - vehicle1.getVehicleType().getLength());
        System.out.println("tp1 = " + tp1.getTrack() + ":" + tp1.getProgression());
        double distance = Track.calculateDistanceFrontBack(tp0, tp1, maxDistance);
        System.out.println("Distance between " + vehicle0 + " and " + vehicle1 + " = " + distance);
        return distance;
    }

    public static double calculateDistanceFrontBack(TrackProgression tp0, TrackProgression tp1, double maxDistance) {
        TrackInterface track = tp0.getTrack();
        double length = track.getLength() - tp0.getProgression();
        double distance = 0.0;
        while (distance < maxDistance) {
            if (track.equals(tp1.getTrack())) {
                return distance + tp1.getProgression();
            }
            distance += length;
            track = track.getEndLink().getActiveSuccessor(track);
            length = track.getLength();
        }
        return -1.0;
    }
}

