/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.vehicle;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVDESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.dsol.statistics.charts.XYChart;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventProducerInterface;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.TimedEvent;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.animation.VehicleAnimation;
import nl.tudelft.simulation.traffic.controlpoint.ControlPointInterface;
import nl.tudelft.simulation.traffic.controlpoint.real.Changeable;
import nl.tudelft.simulation.traffic.controlpoint.real.SpeedLimitInterface;
import nl.tudelft.simulation.traffic.controlpoint.real.StopSignInterface;
import nl.tudelft.simulation.traffic.controlpoint.util.ControlPointsList;
import nl.tudelft.simulation.traffic.track.Track;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;
import nl.tudelft.simulation.traffic.vehicle.AccelerationProfile;
import nl.tudelft.simulation.traffic.vehicle.DecelerationProfile;
import nl.tudelft.simulation.traffic.vehicle.VehicleControlInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePositioner;
import nl.tudelft.simulation.traffic.vehicle.VehicleSegment;
import nl.tudelft.simulation.traffic.vehicle.VehicleType;

public class VehiclePhysical
extends EventProducer
implements VehiclePhysicalInterface {
    private DEVDESSSimulatorInterface simulator;
    private VehicleType vehicleType;
    private VehicleControlInterface vehicleControl;
    private List currentTracks = new ArrayList();
    private double progression;
    private double currentSpeed = 0.0;
    private double distanceTraveled;
    private boolean driving = false;
    private VehiclePositioner vehiclePositioner;
    private double currentMaximumSpeed;
    private AccelerationProfile accelerationProfile;
    private DecelerationProfile decelerationProfile;
    private double horizon;
    private List speedControlPoints = new ArrayList();
    private List trackControlPointsList = new ArrayList();
    private String name;
    private XYChart tvChart;
    private XYChart xvChart;
    public EventType TIME_SPEED_1SECOND_EVENT = new EventType("tv");
    public EventType DISTANCE_SPEED_1SECOND_EVENT = new EventType("xv");
    private double sampleSecond = -10.0;
    private String lastString;
    private double maxBrakeDistance;

    public VehiclePhysical(VehicleType vehicleType, VehicleControlInterface vehicleControl, TrackInterface track, double progression, double maxSpeedStart, DEVDESSSimulatorInterface simulator) {
        try {
            this.simulator = simulator;
            this.distanceTraveled = 0.0;
            this.name = vehicleType.generateUniqueName();
            this.vehicleType = vehicleType;
            this.accelerationProfile = vehicleType.getAccelerationProfile();
            this.decelerationProfile = vehicleType.getDecelerationProfile();
            this.maxBrakeDistance = this.decelerationProfile.getBrakeDistance(vehicleType.getVehicleMaximumSpeed(), 0.0);
            this.horizon = this.maxBrakeDistance * 1.5;
            System.out.println("Horizon for vehicle " + this.name + " is " + this.horizon);
            this.vehicleControl = vehicleControl;
            this.moveToFirstTrack(track, progression);
            this.currentMaximumSpeed = maxSpeedStart;
            if (simulator instanceof AnimatorInterface) {
                ArrayList segments = this.vehicleType.getSegments();
                if (segments.isEmpty()) {
                    new VehicleAnimation(this, (SimulatorInterface)simulator, this.vehicleType.getColor());
                } else {
                    int i = 0;
                    while (i < segments.size()) {
                        VehicleType.Segment segment = (VehicleType.Segment)segments.get(i);
                        new VehicleSegment(this, (DEVSSimulatorInterface)simulator, vehicleType.getColor(), segment.getFront(), segment.getAxle1(), segment.getAxle2(), segment.getLength());
                        ++i;
                    }
                }
                this.tvChart = new XYChart((SimulatorInterface)simulator, "t-v vehicle " + this.name);
                this.tvChart.getChart().getXYPlot().getDomainAxis().setAutoRange(true);
                this.tvChart.getChart().getXYPlot().getDomainAxis().setLabel("time (s)");
                this.tvChart.getChart().getXYPlot().getRangeAxis().setAutoRange(false);
                this.tvChart.getChart().getXYPlot().getRangeAxis().setLowerBound(0.0);
                this.tvChart.getChart().getXYPlot().getRangeAxis().setUpperBound(this.vehicleType.getVehicleMaximumSpeed());
                this.tvChart.getChart().getXYPlot().getRangeAxis().setLabel("speed (m/s)");
                this.TIME_SPEED_1SECOND_EVENT = new EventType("t-v vehicle " + this.name);
                this.tvChart.add("t-v vehicle " + this.name, (EventProducerInterface)this, this.TIME_SPEED_1SECOND_EVENT);
                this.xvChart = new XYChart((SimulatorInterface)simulator, "x-v vehicle " + this.name);
                this.xvChart.getChart().getXYPlot().getDomainAxis().setAutoRange(true);
                this.xvChart.getChart().getXYPlot().getDomainAxis().setLabel("progression (m)");
                this.xvChart.getChart().getXYPlot().getRangeAxis().setAutoRange(false);
                this.xvChart.getChart().getXYPlot().getRangeAxis().setLowerBound(0.0);
                this.xvChart.getChart().getXYPlot().getRangeAxis().setUpperBound(this.vehicleType.getVehicleMaximumSpeed());
                this.xvChart.getChart().getXYPlot().getRangeAxis().setLabel("speed (m/s)");
                this.DISTANCE_SPEED_1SECOND_EVENT = new EventType("x-v vehicle " + this.name);
                this.xvChart.add("x-v vehicle " + this.name, (EventProducerInterface)this, this.DISTANCE_SPEED_1SECOND_EVENT);
            }
            this.vehiclePositioner = new VehiclePositioner(this, (DESSSimulatorInterface)simulator);
            this.vehiclePositioner.setValue(0.0, progression);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized EventType[] getEventTypes() {
        return new EventType[0];
    }

    private void readControlPointsWithinHorizon() {
        Logger.fine((Object)this, (String)"readControlPointsWithinHorizon", (String)(String.valueOf(this.name) + ": Making new horizon list for track " + this.getCurrentTrack()));
        this.speedControlPoints.clear();
        TrackInterface track = this.getCurrentTrack();
        double progression = 0.0;
        while (progression < this.horizon + this.getCurrentTrack().getLength()) {
            if (track == null) {
                return;
            }
            ControlPointsList cpList = track.getControlPoints();
            Iterator it = cpList.iterator();
            while (it.hasNext()) {
                ControlPointInterface cp = (ControlPointInterface)it.next();
                if (cp instanceof Changeable) {
                    try {
                        ((EventProducerInterface)cp).addListener((EventListenerInterface)this, Changeable.CHANGE_STATUS_EVENT);
                    }
                    catch (Exception e) {
                        Logger.severe((Object)this, (String)"readControlPointsWithinHorizon", (Throwable)e);
                    }
                }
                if (!(cp instanceof Changeable) && !(cp instanceof SpeedLimitInterface) && !(cp instanceof StopSignInterface)) continue;
                ControlPointProgression cpp = new ControlPointProgression(cp, progression + cp.getProgression());
                this.speedControlPoints.add(cpp);
                Logger.fine((Object)this, (String)"readControlPointsWithinHorizon", (String)("   ..." + cp + ", distance = " + progression + cp.getProgression()));
            }
            progression += track.getLength();
            TrackLinkInterface link = track.getEndLink();
            track = link.getActiveSuccessor(this.getCurrentTrack());
        }
    }

    public void startDriving() {
        this.driving = true;
    }

    public double getCurrentAcceleration(double speed, double progression) {
        double brakeDistance0;
        double predecessorDistance;
        try {
            double time = this.simulator.getSimulatorTime();
            if (time - this.sampleSecond > 1.0) {
                this.fireEvent((EventInterface)new TimedEvent(this.TIME_SPEED_1SECOND_EVENT, (Object)this, (Object)new Double(speed), time));
                this.fireEvent((EventInterface)new TimedEvent(this.DISTANCE_SPEED_1SECOND_EVENT, (Object)this, (Object)new Double(speed), this.distanceTraveled));
                this.sampleSecond = time;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (!this.driving) {
            return 0.0;
        }
        double accdec = 0.0;
        if (speed < this.currentMaximumSpeed) {
            accdec = this.accelerationProfile.getAcceleration(speed);
        }
        if ((predecessorDistance = this.calculatePredecessorDistance(progression, brakeDistance0 = this.decelerationProfile.getBrakeDistance(speed, 0.0) + 1.01)) < brakeDistance0) {
            if (speed > 0.0) {
                return this.decelerationProfile.getDeceleration(speed);
            }
            return 0.0;
        }
        Iterator it = this.speedControlPoints.iterator();
        boolean finished = false;
        while (it.hasNext() && !finished) {
            ControlPointProgression cpp = (ControlPointProgression)it.next();
            ControlPointInterface cp = cpp.getControlPoint();
            double cpDistance = cpp.getDistance() - progression;
            if (cpDistance > brakeDistance0) {
                finished = true;
            }
            if (!(cpDistance > 0.0)) continue;
            if (cp instanceof SpeedLimitInterface) {
                if (!(cpDistance <= this.decelerationProfile.getBrakeDistance(speed, ((SpeedLimitInterface)cp).getSpeedLimit()))) continue;
                if (!cp.toString().equals(this.lastString)) {
                    this.lastString = cp.toString();
                    Logger.fine((Object)this, (String)"getCurrentAcceleration", (String)(String.valueOf(this.name) + " braking for speedlimit cp " + this.lastString + ", cpDistance=" + cpDistance + "\n   brakeDistance=" + this.decelerationProfile.getBrakeDistance(speed, ((SpeedLimitInterface)cp).getSpeedLimit()) + ", progression=" + this.progression + "\n   track=" + this.getCurrentTrack() + ", length=" + this.getCurrentTrack().getLength()));
                }
                accdec = this.decelerationProfile.getDeceleration(speed);
                finished = true;
                continue;
            }
            if (!(cp instanceof StopSignInterface)) continue;
            if (((StopSignInterface)cp).getStatus().equals("STOP") && cpDistance <= brakeDistance0) {
                if (!cp.toString().equals(this.lastString)) {
                    this.lastString = cp.toString();
                    Logger.fine((Object)this, (String)"getCurrentAcceleration", (String)(String.valueOf(this.name) + " braking for trafficlight cp " + this.lastString + ", cpDistance=" + cpDistance + "\n   brakeDistance=" + brakeDistance0 + ", progression=" + this.progression + "\n   track=" + this.getCurrentTrack() + ", length=" + this.getCurrentTrack().getLength()));
                }
                accdec = this.decelerationProfile.getDeceleration(speed);
                finished = true;
            }
            if (!((StopSignInterface)cp).getStatus().equals("STOP") || !(cpDistance <= 1.01)) continue;
            accdec = speed > 0.0 ? this.decelerationProfile.getDeceleration(speed) : 0.0;
        }
        return accdec;
    }

    public double[] setSpeedAndProgression(double speed, double progression) {
        this.currentSpeed = speed;
        this.distanceTraveled += progression - this.progression;
        TrackInterface track = this.getCurrentTrack();
        if (progression < track.getLength()) {
            this.driveOverControlPoints(this.progression, progression);
            this.progression = progression;
        } else {
            this.driveOverControlPoints(this.progression, track.getLength());
            double restProgression = Math.max(0.0, track.getLength() - this.progression);
            this.moveToNextTrack();
            track = this.getCurrentTrack();
            this.driveOverControlPoints(0.0, restProgression);
            this.vehiclePositioner.setValue(this.currentSpeed, restProgression);
            this.progression = restProgression;
        }
        return new double[]{this.currentSpeed, this.progression};
    }

    protected void moveToNextTrack() {
        this.getCurrentTrack().removeVehicle(this);
        TrackLinkInterface link = this.getCurrentTrack().getEndLink();
        TrackInterface newCurrentTrack = link.getActiveSuccessor(this.getCurrentTrack());
        this.progression = 0.0;
        this.currentTracks.add(newCurrentTrack);
        Logger.fine((Object)this, (String)"moveToNextTrack", (String)(String.valueOf(this.name) + " moved to next track " + this.getCurrentTrack()));
        this.readControlPointsWithinHorizon();
        this.makeControlPointsArray(newCurrentTrack);
        newCurrentTrack.addVehicle(this);
    }

    protected void moveToFirstTrack(TrackInterface track, double progression) {
        this.currentTracks.add(track);
        this.progression = progression;
        this.currentTracks.add(track);
        this.readControlPointsWithinHorizon();
        this.makeControlPointsArray(track);
        track.addVehicle(this);
    }

    private double calculatePredecessorDistance(double progression, double maxDistance) {
        double rest = maxDistance;
        TrackInterface track = this.getCurrentTrack();
        double length = track.getLength() - progression;
        while (rest > 0.0) {
            List vehicleList = track.getVehiclesOnTrack();
            int i = 0;
            while (i < vehicleList.size()) {
                double distance;
                VehiclePhysicalInterface vehicle = (VehiclePhysicalInterface)vehicleList.get(i);
                if (vehicle != this && (distance = Track.calculateDistanceFrontBack(this, vehicle)) > 0.0) {
                    return distance;
                }
                ++i;
            }
            rest -= length;
            if ((track = track.getEndLink().getActiveSuccessor(track)) == null) {
                return maxDistance + 1.0;
            }
            length = track.getLength();
        }
        return maxDistance + 1.0;
    }

    private void makeControlPointsArray(TrackInterface track) {
        this.trackControlPointsList.clear();
        ControlPointsList cpl = track.getControlPoints();
        Iterator it = cpl.iterator();
        while (it.hasNext()) {
            ControlPointInterface cp = (ControlPointInterface)it.next();
            this.trackControlPointsList.add(cp);
        }
    }

    protected void driveOverControlPoints(double from, double to) {
        boolean finished = false;
        while (!finished) {
            if (this.trackControlPointsList.size() == 0) {
                finished = true;
                continue;
            }
            ControlPointInterface cp = (ControlPointInterface)this.trackControlPointsList.get(0);
            if (cp.getProgression() >= from - 0.001 && cp.getProgression() <= to + 0.001) {
                System.out.println(String.valueOf(this.name) + " drove over cp " + cp);
                this.trackControlPointsList.remove(0);
                Iterator it = this.speedControlPoints.iterator();
                while (it.hasNext()) {
                    ControlPointProgression cpp = (ControlPointProgression)it.next();
                    if (!cpp.getControlPoint().equals(cp)) continue;
                    System.out.println("also removed from speedControlPoints: " + cp);
                    it.remove();
                }
                cp.pass(this);
                continue;
            }
            finished = true;
        }
    }

    public double getCurrentSpeed() {
        return this.currentSpeed;
    }

    public void setMaximumSpeed(double maxSpeed) {
        this.currentMaximumSpeed = maxSpeed;
    }

    public double getProgression() {
        return this.progression;
    }

    public TrackInterface getCurrentTrack() {
        return (TrackInterface)this.currentTracks.get(this.currentTracks.size() - 1);
    }

    public VehicleType getVehicleType() {
        return this.vehicleType;
    }

    public VehicleControlInterface getVehicleControl() {
        return this.vehicleControl;
    }

    public void setVehicleControl(VehicleControlInterface vehicleControl) {
        this.vehicleControl = vehicleControl;
    }

    public double getDistanceTraveled() {
        return this.distanceTraveled;
    }

    public void removeVehicle() throws RemoteException {
        this.getCurrentTrack().removeVehicle(this);
        this.vehicleControl.removeVehicle();
        this.fireEvent(VehiclePhysicalInterface.REMOVE_EVENT, true);
        this.removeAllListeners();
        this.vehiclePositioner.stopIntegration();
        this.driving = false;
    }

    public void notify(EventInterface event) throws RemoteException {
        if (event.getType().equals((Object)Changeable.CHANGE_STATUS_EVENT)) {
            if (!this.driving) {
                ((EventProducerInterface)event.getSource()).removeListener((EventListenerInterface)this, Changeable.CHANGE_STATUS_EVENT);
            }
            this.readControlPointsWithinHorizon();
        } else {
            System.err.println("Vehicle " + this.name + ": unknown event: " + event);
        }
    }

    protected double getCurrentTracksLength() {
        double totalLength = 0.0;
        int i = 0;
        while (i < this.currentTracks.size()) {
            totalLength += ((TrackInterface)this.currentTracks.get(i)).getLength();
            ++i;
        }
        return totalLength;
    }

    public DirectedPoint getLocation() {
        DirectedPoint front = this.getCurrentTrack().getLocationOfProgression(this.progression);
        TrackProgression tp = this.getCurrentTrack().calculateTrackProgressionListActive(this.progression - this.vehicleType.getLength());
        if (tp == null) {
            tp = this.getCurrentTrack().calculateTrackProgressionListActive(this.progression - 0.1);
        }
        if (tp == null) {
            return new DirectedPoint(front.x, front.y, 0.1, 0.0, 0.0, 0.0);
        }
        DirectedPoint back = tp.getTrack().getLocationOfProgression(tp.getProgression());
        double theta = Math.atan2(back.y - front.y, back.x - front.x);
        return new DirectedPoint(front.x, front.y, front.z + 0.05, 0.0, 0.0, theta);
    }

    public Point3d getBackwardLocation(double distance) {
        TrackProgression tp = this.getCurrentTrack().calculateTrackProgressionListActive(this.progression - distance);
        if (tp == null) {
            System.err.println("ERROR " + this.name + ": cannot calculate backwardLocation from " + this.getCurrentTrack() + ", progression=" + this.progression + ", back distance=" + distance);
            tp = this.getCurrentTrack().calculateTrackProgressionListActive(this.progression);
            if (tp == null) {
                return new DirectedPoint(0.0, 0.0, 0.0);
            }
        }
        DirectedPoint back = tp.getTrack().getLocationOfProgression(tp.getProgression());
        return new Point3d(back.x, back.y, back.z);
    }

    public Bounds getBounds() {
        DirectedPoint location = this.getLocation();
        double width = this.vehicleType.getWidth();
        BoundingBox box = new BoundingBox(new Point3d(0.0, -width / 2.0, 0.0), new Point3d(this.vehicleType.getLength(), width / 2.0, 0.0));
        Transform3D rot = new Transform3D();
        rot.rotZ(location.getRotZ());
        box.transform(rot);
        return box;
    }

    public String toString() {
        return this.name;
    }

    private class ControlPointProgression {
        private ControlPointInterface controlPoint;
        private double distance;

        public ControlPointProgression(ControlPointInterface controlPoint, double distance) {
            this.controlPoint = controlPoint;
            this.distance = distance;
        }

        public ControlPointInterface getControlPoint() {
            return this.controlPoint;
        }

        public double getDistance() {
            return this.distance;
        }

        public String toString() {
            return "CPP:" + this.controlPoint + ", distance:" + this.distance;
        }
    }
}

