/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.vehicle;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.formalisms.dess.DifferentialEquation;
import nl.tudelft.simulation.dsol.simulators.DESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysical;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class VehiclePositioner
extends DifferentialEquation {
    protected VehiclePhysicalInterface vehiclePhysical;

    public VehiclePositioner(VehiclePhysicalInterface vehiclePhysical, DESSSimulatorInterface simulator) throws RemoteException {
        this(vehiclePhysical, simulator, simulator.getTimeStep(), 3);
    }

    public VehiclePositioner(VehiclePhysicalInterface vehiclePhysical, DESSSimulatorInterface simulator, double timeStep) {
        this(vehiclePhysical, simulator, timeStep, 3);
    }

    public VehiclePositioner(VehiclePhysicalInterface vehiclePhysical, DESSSimulatorInterface simulator, double timeStep, short numericalMethod) {
        super(simulator, timeStep, numericalMethod);
        this.vehiclePhysical = vehiclePhysical;
        this.initialize(0.0, new double[]{0.0, 0.0});
    }

    public VehiclePositioner(VehiclePhysical vehiclePhysical, DESSSimulatorInterface simulator, double timeStep, NumericalIntegrator numericalIntegrator) {
        super(simulator, timeStep, numericalIntegrator);
        this.vehiclePhysical = vehiclePhysical;
        this.initialize(0.0, new double[]{0.0, 0.0});
    }

    public void setValue(double speed, double progression) {
        try {
            super.initialize(this.simulator.getSimulatorTime(), new double[]{speed, progression});
        }
        catch (RemoteException exception) {
            Logger.warning((Object)((Object)this), (String)"setValue", (Throwable)exception);
        }
    }

    public double[] dy(double x, double[] y) {
        double[] dy = new double[]{this.vehiclePhysical.getCurrentAcceleration(y[0], y[1]), y[0]};
        return dy;
    }

    protected double[] integrateY(double x, double initialX, double[] initialY) {
        double[] y = super.integrateY(x, initialX, initialY);
        y[0] = Math.max(0.0, y[0]);
        y = this.vehiclePhysical.setSpeedAndProgression(y[0], y[1]);
        return y;
    }

    public void stopIntegration() {
        try {
            this.simulator.removeListener((EventListenerInterface)this, SimulatorInterface.TIME_CHANGED_EVENT);
        }
        catch (RemoteException e) {
            Logger.warning((Object)((Object)this), (String)"stopIntegration", (Throwable)e);
        }
    }
}

