/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.vehicle;

import java.awt.Color;
import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.SegmentedVehicleAnimation;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class VehicleSegment
implements LocatableInterface {
    private VehiclePhysicalInterface vehicle;
    private double front;
    private double axle1;
    private double axle2;
    private double length;

    public VehicleSegment(VehiclePhysicalInterface vehicle, DEVSSimulatorInterface devs, Color color, double front, double axle1, double axle2, double length) {
        this.vehicle = vehicle;
        this.front = front;
        this.axle1 = axle1;
        this.axle2 = axle2;
        this.length = length;
        if (devs instanceof AnimatorInterface) {
            new SegmentedVehicleAnimation(this, (SimulatorInterface)devs, color);
        }
    }

    public double getAxle1() {
        return this.axle1;
    }

    public double getAxle2() {
        return this.axle2;
    }

    public double getFront() {
        return this.front;
    }

    public double getLength() {
        return this.length;
    }

    public DirectedPoint getLocation() throws RemoteException {
        Point3d front = this.vehicle.getBackwardLocation(this.front);
        Point3d back = this.vehicle.getBackwardLocation(this.front + this.length);
        double theta = Math.atan2(back.y - front.y, back.x - front.x);
        return new DirectedPoint(front.x, front.y, front.z + 0.05, 0.0, 0.0, theta);
    }

    public Bounds getBounds() throws RemoteException {
        DirectedPoint location = this.getLocation();
        double width = this.vehicle.getVehicleType().getWidth();
        BoundingBox box = new BoundingBox(new Point3d(0.0, -width / 2.0, 0.0), new Point3d(this.length, width / 2.0, 0.0));
        Transform3D rot = new Transform3D();
        rot.rotZ(location.getRotZ());
        box.transform(rot);
        return box;
    }

    public VehiclePhysicalInterface getVehicle() {
        return this.vehicle;
    }
}

