/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.vehicle;

import java.awt.Color;
import java.util.ArrayList;
import nl.tudelft.simulation.traffic.vehicle.AccelerationProfile;
import nl.tudelft.simulation.traffic.vehicle.DecelerationProfile;

public class VehicleType {
    private String name;
    private double length;
    private double width;
    private Color color;
    private ArrayList segments = new ArrayList();
    private int number = 0;
    private double vehicleMaximumSpeed;
    private AccelerationProfile accelerationProfile;
    private DecelerationProfile decelerationProfile;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void addSegment(double front, double axle1, double axle2, double length) {
        Segment segment = new Segment(front, axle1, axle2, length);
        this.segments.add(segment);
    }

    public ArrayList getSegments() {
        return this.segments;
    }

    public double getVehicleMaximumSpeed() {
        return this.vehicleMaximumSpeed;
    }

    public void setVehicleMaximumSpeed(double vehicleMaximumSpeed) {
        this.vehicleMaximumSpeed = vehicleMaximumSpeed;
    }

    public AccelerationProfile getAccelerationProfile() {
        return this.accelerationProfile;
    }

    public void setAccelerationProfile(AccelerationProfile accelerationProfile) {
        this.accelerationProfile = accelerationProfile;
        this.accelerationProfile.initializeProfile();
    }

    public DecelerationProfile getDecelerationProfile() {
        return this.decelerationProfile;
    }

    public void setDecelerationProfile(DecelerationProfile decelerationProfile) {
        this.decelerationProfile = decelerationProfile;
        this.decelerationProfile.initializeProfile();
    }

    public String generateUniqueName() {
        ++this.number;
        return String.valueOf(this.name) + "." + this.number;
    }

    public class Segment {
        private double front;
        private double axle1;
        private double axle2;
        private double length;

        public Segment(double front, double axle1, double axle2, double length) {
            this.front = front;
            this.axle1 = axle1;
            this.axle2 = axle2;
            this.length = length;
        }

        public double getAxle1() {
            return this.axle1;
        }

        public double getAxle2() {
            return this.axle2;
        }

        public double getFront() {
            return this.front;
        }

        public double getLength() {
            return this.length;
        }
    }
}

