/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.track.ArcTrack;
import nl.tudelft.simulation.traffic.track.Track;

public class ArcTrackAnimation
extends Renderable2D {
    private double dx;
    private double dy;
    private ArcTrack owner;
    private double width;
    private double cx;
    private double cy;

    public ArcTrackAnimation(ArcTrack owner, SimulatorInterface simulator, double width) throws Exception {
        super((LocatableInterface)owner, simulator);
        this.dx = ((Track)this.source).getdx();
        this.dy = -((Track)this.source).getdy();
        this.owner = owner;
        this.width = width;
        this.cx = this.owner.getCenter().getX() - this.owner.getLocation().x;
        this.cy = -(this.owner.getCenter().getY() - this.owner.getLocation().y);
    }

    public void paint(Graphics2D gr, ImageObserver io) {
        try {
            gr.setColor(Color.LIGHT_GRAY);
            gr.setStroke(new BasicStroke(0.05f));
            Arc2D.Double arc = new Arc2D.Double();
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius(), 0.0, 0.0, 2);
            if (this.owner.isCounterClockwise()) {
                arc.setAngles(0.0, 0.0, this.dx, this.dy);
            } else {
                arc.setAngles(this.dx, this.dy, 0.0, 0.0);
            }
            double angleStart = ((Arc2D)arc).getAngleStart();
            double angleExtent = ((Arc2D)arc).getAngleExtent();
            gr.setColor(Color.BLUE);
            gr.setStroke(new BasicStroke(0.1f));
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius(), angleStart, angleExtent, 0);
            gr.draw(arc);
            gr.setColor(Color.GREEN);
            gr.setStroke(new BasicStroke(0.1f));
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius() - this.width / 2.0, angleStart, angleExtent, 0);
            gr.draw(arc);
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius() + this.width / 2.0, angleStart, angleExtent, 0);
            gr.draw(arc);
            arc.setArcByCenter(this.cx, this.cy, this.owner.getRadius(), angleStart, angleExtent / 2.0, 0);
            Point2D half = arc.getEndPoint();
            gr.setColor(Color.BLACK);
            Font font = new Font("SansSerif", 0, 2).deriveFont(1.0f);
            gr.setFont(font);
            gr.drawString(this.source.toString(), (float)half.getX(), (float)half.getY());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean contains(Point2D pointWorldCoordinates, Rectangle2D extent, Dimension screen) {
        return false;
    }
}

