/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.animation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;
import nl.tudelft.simulation.traffic.vehicle.VehicleSegment;

public class SegmentedVehicleAnimation
extends Renderable2D
implements EventListenerInterface {
    private VehicleSegment segment;
    private Color color;

    public SegmentedVehicleAnimation(VehicleSegment segment, SimulatorInterface simulator, Color color) {
        super((LocatableInterface)segment, simulator);
        try {
            segment.getVehicle().addListener(this, VehiclePhysicalInterface.REMOVE_EVENT);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.segment = segment;
        this.color = color;
    }

    public void paint(Graphics2D gr, ImageObserver imo) {
        if (this.segment == null) {
            return;
        }
        double width = this.segment.getVehicle().getVehicleType().getWidth();
        double length = this.segment.getLength();
        gr.setColor(this.color);
        gr.fill(new RoundRectangle2D.Double(0.0, -width / 2.0, length, width, width / 2.0, width / 2.0));
    }

    public void notify(EventInterface event) throws RemoteException {
        if (event.getType().equals((Object)VehiclePhysicalInterface.REMOVE_EVENT)) {
            super.destroy();
            this.segment = null;
        }
    }
}

