/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.track.Track;
import nl.tudelft.simulation.traffic.track.TrackInterface;

public class StraightTrackAnimation
extends Renderable2D {
    private double dx;
    private double dy;
    private double width;

    public StraightTrackAnimation(TrackInterface owner, SimulatorInterface simulator, double width) {
        super((LocatableInterface)owner, simulator);
        this.dx = ((Track)this.source).getdx();
        this.dy = -((Track)this.source).getdy();
        this.width = width;
    }

    public void paint(Graphics2D gr, ImageObserver io) {
        try {
            gr.setColor(Color.BLUE);
            gr.setStroke(new BasicStroke(0.1f));
            gr.draw(new Line2D.Double(0.0, 0.0, this.dx, this.dy));
            double alpha = Math.atan2(this.dy, this.dx);
            double wx = this.width * Math.sin(alpha) / 2.0;
            double wy = this.width * Math.cos(alpha) / 2.0;
            gr.setColor(Color.GREEN);
            gr.setStroke(new BasicStroke(0.1f));
            gr.draw(new Line2D.Double(wx, -wy, this.dx + wx, this.dy - wy));
            gr.draw(new Line2D.Double(-wx, wy, this.dx - wx, this.dy + wy));
            double deltax = this.dx / 2.0;
            double deltay = this.dy / 2.0;
            gr.setColor(Color.BLACK);
            Font font = new Font("SansSerif", 0, 2).deriveFont(1.0f);
            gr.setFont(font);
            gr.drawString(this.source.toString(), (float)(deltax - 3.0), (float)(deltay - 1.0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean contains(Point2D pointWorldCoordinates, Rectangle2D extent, Dimension screen) {
        return false;
    }
}

