/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.animation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.real.StopSignInterface;

public class TrafficLightAnimation
extends Renderable2D {
    private double deltax;
    private double deltay;

    public TrafficLightAnimation(LocatableInterface owner, SimulatorInterface simulator) {
        this(owner, simulator, 0.0, 0.0);
    }

    public TrafficLightAnimation(LocatableInterface owner, SimulatorInterface simulator, double deltax, double deltay) {
        super(owner, simulator);
        this.deltax = deltax;
        this.deltay = -deltay;
    }

    public void paint(Graphics2D graphics, ImageObserver imo) throws RemoteException {
        StopSignInterface trafficLight = (StopSignInterface)this.source;
        graphics.setColor(Color.BLACK);
        graphics.setStroke(new BasicStroke(0.05f));
        graphics.draw(new Line2D.Double(0.0, 0.0, this.deltax, this.deltay));
        graphics.fill(new Rectangle2D.Double(this.deltax - 2.0, this.deltay - 8.0, 4.0, 8.0));
        if (trafficLight.getStatus() == "CONT") {
            graphics.setColor(Color.GREEN);
            graphics.fill(new Ellipse2D.Double(this.deltax - 1.5, this.deltay - 3.5, 3.0, 3.0));
        } else {
            graphics.setColor(Color.RED);
            graphics.fill(new Ellipse2D.Double(this.deltax - 1.5, this.deltay - 7.5, 3.0, 3.0));
        }
        graphics.setColor(Color.BLACK);
        Font smallFont = new Font("SansSerif", 0, 2);
        graphics.setFont(smallFont);
        graphics.drawString(this.source.toString(), (float)(this.deltax + 4.0), (float)this.deltay);
    }
}

