/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.animation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class VehicleAnimation
extends Renderable2D
implements EventListenerInterface {
    private VehiclePhysicalInterface vehiclePhysical;
    private Color color;

    public VehicleAnimation(VehiclePhysicalInterface source, SimulatorInterface simulator, Color color) {
        super((LocatableInterface)source, simulator);
        this.vehiclePhysical = source;
        this.color = color;
        try {
            this.vehiclePhysical.addListener(this, VehiclePhysicalInterface.REMOVE_EVENT);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics2D gr, ImageObserver imo) {
        if (this.vehiclePhysical == null) {
            return;
        }
        double length = this.vehiclePhysical.getVehicleType().getLength();
        double width = this.vehiclePhysical.getVehicleType().getWidth();
        gr.setColor(this.color);
        gr.fill(new Rectangle2D.Double(0.0, -width / 2.0, length, width));
    }

    public void notify(EventInterface event) throws RemoteException {
        if (event.getType().equals((Object)VehiclePhysicalInterface.REMOVE_EVENT)) {
            super.destroy();
            this.vehiclePhysical = null;
        }
    }
}

