/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.controlpoint.blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.jstats.distributions.DistConstant;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.streams.Java2Random;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.traffic.controlpoint.blocks.SwitchBlockTrafficLight;
import nl.tudelft.simulation.traffic.controlpoint.blocks.VirtualBlock;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class VirtualSwitchBlock
extends VirtualBlock {
    private Map directions = new HashMap();
    private DEVSSimulatorInterface simulator;
    private DistContinuous switchTime;

    public VirtualSwitchBlock(String name, DEVSSimulatorInterface simulator, DistContinuous switchTime) {
        super(name);
        this.simulator = simulator;
        this.switchTime = switchTime;
        if (switchTime == null) {
            this.switchTime = new DistConstant((StreamInterface)new Java2Random(), 2.0);
        }
    }

    public void addSwitchDirection(SwitchBlockTrafficLight trafficLight, List lineList, double distanceRelease, TrackInterface fromTrack, TrackInterface toTrack) {
        int i = 0;
        while (i < lineList.size()) {
            Direction direction = new Direction(trafficLight, (String)lineList.get(i), distanceRelease, fromTrack, toTrack);
            String key = this.makeDirectionKey(trafficLight, (String)lineList.get(i));
            System.out.println("Added directionKey = " + key);
            this.directions.put(key, direction);
            trafficLight.setDistanceRelease(distanceRelease);
            System.out.println("addSwitchDirection distanceRelease: " + direction.getDistanceRelease() + ", trafficlight.releaseDistance: " + trafficLight.getDistanceRelease());
            trafficLight.addSensors(trafficLight.getTrack(), trafficLight.getProgression() + trafficLight.getDistanceRelease(), 2, (String)lineList.get(i), this.simulator);
            System.out.println(String.valueOf(trafficLight.getName()) + ", release distance: " + direction.getDistanceRelease() + ", distance Red: " + trafficLight.getDistanceRed() + ", distance request: " + trafficLight.getDistanceRequest());
            ++i;
        }
    }

    private String makeDirectionKey(SwitchBlockTrafficLight trafficLight, String line) {
        return String.valueOf(trafficLight.toString()) + "@" + line;
    }

    public void requestAccess(SwitchBlockTrafficLight switchBlockTrafficLight) {
        VehiclePhysicalInterface vehicle = switchBlockTrafficLight.getRequestingVehicle();
        System.out.println("VirtualSwitchBlock - request access line " + vehicle.getVehicleControl().getLine() + " at " + switchBlockTrafficLight.getName());
        if (this.busy == 0) {
            ++this.busy;
            System.out.println("variable busy:" + this.busy);
            this.changeSwitchDirection(switchBlockTrafficLight, vehicle.getVehicleControl().getLine());
        } else {
            this.requestList.add(switchBlockTrafficLight);
        }
    }

    private void changeSwitchDirection(SwitchBlockTrafficLight switchBlockTrafficLight, String line) {
        System.out.println(this.makeDirectionKey(switchBlockTrafficLight, line));
        Direction direction = (Direction)this.directions.get(this.makeDirectionKey(switchBlockTrafficLight, line));
        System.out.println("changing switch direction. Release distance to be activated: " + direction.getDistanceRelease());
        switchBlockTrafficLight.setDistanceRelease(direction.getDistanceRelease());
        TrackInterface fromTrack = direction.getFromTrack();
        TrackInterface toTrack = direction.getToTrack();
        TrackLinkInterface startLink = toTrack.getStartLink();
        if (startLink.getActiveSuccessor(fromTrack).equals(toTrack)) {
            System.out.println(String.valueOf(startLink.toString()) + " Switch already on the right position");
        } else if (!startLink.getActiveSuccessor(fromTrack).equals(toTrack)) {
            try {
                this.simulator.scheduleEvent(this.switchTime.draw(), (Object)this, (Object)this, "turnSwitch", new Object[]{startLink, fromTrack, toTrack, switchBlockTrafficLight});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            switchBlockTrafficLight.changeState("GREEN");
        }
    }

    protected void turnSwitch(TrackLinkInterface startLink, TrackInterface fromTrack, TrackInterface toTrack, SwitchBlockTrafficLight switchBlockTrafficLight) {
        startLink.setActiveSuccessor(fromTrack, toTrack);
        switchBlockTrafficLight.changeState("GREEN");
    }

    private static class Direction {
        private SwitchBlockTrafficLight trafficLight = null;
        private String line;
        private double distanceRelease = 0.0;
        private TrackInterface fromTrack = null;
        private TrackInterface toTrack = null;

        public Direction(SwitchBlockTrafficLight trafficLight, String line, double distanceRelease, TrackInterface fromTrack, TrackInterface toTrack) {
            this.trafficLight = trafficLight;
            this.distanceRelease = distanceRelease;
            this.line = line;
            this.fromTrack = fromTrack;
            this.toTrack = toTrack;
            System.out.println("Direction added: " + this.trafficLight + ", " + this.distanceRelease + ", " + this.line + ", " + this.fromTrack.toString() + ", " + this.toTrack.toString());
        }

        public String getLine() {
            return this.line;
        }

        public TrackInterface getFromTrack() {
            return this.fromTrack;
        }

        public TrackInterface getToTrack() {
            return this.toTrack;
        }

        public SwitchBlockTrafficLight getTrafficLight() {
            return this.trafficLight;
        }

        public double getDistanceRelease() {
            return this.distanceRelease;
        }
    }
}

