/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.controlpoint.real;

import java.rmi.RemoteException;
import java.util.List;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.ControlPointAnimation;
import nl.tudelft.simulation.traffic.controlpoint.real.VisibleControlPointInterface;
import nl.tudelft.simulation.traffic.controlpoint.util.ControlPointsList;
import nl.tudelft.simulation.traffic.controlpoint.virtual.Show;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;

public abstract class AbstractVisibleControlPoint
extends EventProducer
implements VisibleControlPointInterface {
    private ControlPointsList showControlPoints = new ControlPointsList();
    protected TrackInterface track;
    protected double progression;
    private double visibleDistance;
    private DirectedPoint location;

    public AbstractVisibleControlPoint(TrackInterface track, double progression, double visibleDistance, SimulatorInterface simulator) {
        TrackProgression tp = track.calculateTrackProgressionListActive(progression);
        this.track = tp.getTrack();
        this.progression = tp.getProgression();
        this.location = this.track.getLocationOfProgression(this.progression);
        this.location.setRotZ(0.0);
        this.visibleDistance = visibleDistance;
        this.track.addControlPoint(this);
        double vcpProg = visibleDistance - this.progression;
        this.buildShowControlPoints(this.track, vcpProg, simulator);
        if (simulator instanceof AnimatorInterface) {
            new ControlPointAnimation(this, simulator);
        }
    }

    private void buildShowControlPoints(TrackInterface track, double visibleDistance, SimulatorInterface simulator) {
        List tpList = track.calculateTrackProgressionListAll(-visibleDistance);
        int i = 0;
        while (i < tpList.size()) {
            TrackProgression tp = (TrackProgression)tpList.get(i);
            Show show = new Show(tp.getTrack(), tp.getProgression(), this, simulator);
            this.showControlPoints.add(show);
            System.out.println(this + ", show " + " added on track " + tp.getTrack() + ", progression " + tp.getProgression());
            ++i;
        }
    }

    public double getProgression() {
        return this.progression;
    }

    public TrackInterface getTrack() {
        return this.track;
    }

    public double getVisibleDistance() {
        return this.visibleDistance;
    }

    public Bounds getBounds() throws RemoteException {
        return new BoundingBox(new Point3d(-0.1, -0.1, 0.0), new Point3d(0.1, 0.1, 0.0));
    }

    public DirectedPoint getLocation() throws RemoteException {
        return this.location;
    }
}

