/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.controlpoint.real;

import java.rmi.RemoteException;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.SimRuntimeException;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEvent;
import nl.tudelft.simulation.dsol.formalisms.devs.SimEventInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.TrafficLightAnimation;
import nl.tudelft.simulation.traffic.controlpoint.real.AbstractVisibleControlPoint;
import nl.tudelft.simulation.traffic.controlpoint.real.Changeable;
import nl.tudelft.simulation.traffic.controlpoint.real.StopSignInterface;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class TrafficLight
extends AbstractVisibleControlPoint
implements StopSignInterface,
LocatableInterface {
    private DEVSSimulatorInterface simulator;
    private DistContinuous durationRed;
    private DistContinuous durationGreen;
    private String status;
    private String name;
    private double dx;
    private double dy;

    public TrafficLight(String name, double progression, double visibleDistance, TrackInterface track, DistContinuous durationGreen, DistContinuous durationRed, String status, DEVSSimulatorInterface simulator, double dx, double dy) {
        super(track, progression, visibleDistance, (SimulatorInterface)simulator);
        this.name = name;
        System.out.println(this + ", placed on " + track + " progression " + progression + " (length=" + track.getLength() + ")");
        this.status = status;
        this.durationRed = durationRed;
        this.durationGreen = durationGreen;
        this.simulator = simulator;
        this.dx = dx;
        this.dy = dy;
        if (simulator instanceof AnimatorInterface) {
            new TrafficLightAnimation(this, (SimulatorInterface)simulator, dx, dy);
        }
        double timeToNext = 0.0;
        try {
            timeToNext = this.status.equals("CONT") ? this.durationGreen.draw() : this.durationRed.draw();
            SimEvent simEvent = new SimEvent(simulator.getSimulatorTime() + timeToNext, (Object)this, (Object)this, "changeStatus", null);
            simulator.scheduleEvent((SimEventInterface)simEvent);
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (SimRuntimeException e1) {
            e1.printStackTrace();
        }
    }

    protected void changeStatus() throws Exception {
        Event event;
        double timeToNext = 0.0;
        if (this.status == "CONT") {
            this.status = "STOP";
            event = new Event(Changeable.CHANGE_STATUS_EVENT, (Object)this, null);
            this.fireEvent((EventInterface)event);
            timeToNext = this.durationRed.draw();
        } else {
            this.status = "CONT";
            event = new Event(Changeable.CHANGE_STATUS_EVENT, (Object)this, null);
            this.fireEvent((EventInterface)event);
            timeToNext = this.durationGreen.draw();
        }
        SimEvent simEvent = new SimEvent(this.simulator.getSimulatorTime() + timeToNext, (Object)this, (Object)this, "changeStatus", null);
        this.simulator.scheduleEvent((SimEventInterface)simEvent);
    }

    public void pass(VehiclePhysicalInterface vehicle) {
        this.removeListener(vehicle, Changeable.CHANGE_STATUS_EVENT);
    }

    public double getProgression() {
        return super.getProgression();
    }

    public String getStatus() {
        return this.status;
    }

    public DirectedPoint getLocation() throws RemoteException {
        DirectedPoint p = super.getTrack().getLocationOfProgression(super.getProgression());
        return new DirectedPoint(p.x, p.y, p.z);
    }

    public TrackInterface getTrack() {
        return super.getTrack();
    }

    public Bounds getBounds() throws RemoteException {
        return new BoundingBox(new Point3d(this.dx - 2.0, this.dy, 0.0), new Point3d(this.dx + 2.0, this.dy + 8.0, 0.0));
    }

    public String toString() {
        return "TrafficLight " + this.name;
    }
}

