/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.file;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import nl.tudelft.simulation.dsol.experiment.TimeUnit;
import nl.tudelft.simulation.dsol.experiment.TimeUnitInterface;
import nl.tudelft.simulation.dsol.simulators.DEVDESSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.jstats.distributions.DistConstant;
import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.distributions.DistExponential;
import nl.tudelft.simulation.jstats.distributions.DistNormal;
import nl.tudelft.simulation.jstats.distributions.DistTriangular;
import nl.tudelft.simulation.jstats.streams.Java2Random;
import nl.tudelft.simulation.jstats.streams.StreamInterface;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.animation.ArcTrackAnimation;
import nl.tudelft.simulation.traffic.animation.StraightTrackAnimation;
import nl.tudelft.simulation.traffic.controlpoint.blocks.BlockTrafficLight;
import nl.tudelft.simulation.traffic.controlpoint.blocks.SwitchBlockTrafficLight;
import nl.tudelft.simulation.traffic.controlpoint.blocks.VirtualSwitchBlock;
import nl.tudelft.simulation.traffic.controlpoint.real.RemoveControlPoint;
import nl.tudelft.simulation.traffic.controlpoint.real.SpeedSign;
import nl.tudelft.simulation.traffic.controlpoint.real.TrafficLight;
import nl.tudelft.simulation.traffic.station.Station;
import nl.tudelft.simulation.traffic.track.ArcTrack;
import nl.tudelft.simulation.traffic.track.ComplexTrackLink;
import nl.tudelft.simulation.traffic.track.SimpleTrackLink;
import nl.tudelft.simulation.traffic.track.StraightTrack;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;
import nl.tudelft.simulation.traffic.track.VirtualTrack;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;
import nl.tudelft.simulation.traffic.vehicle.AccelerationProfile;
import nl.tudelft.simulation.traffic.vehicle.DecelerationProfile;
import nl.tudelft.simulation.traffic.vehicle.VehicleControl;
import nl.tudelft.simulation.traffic.vehicle.VehicleControlInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysical;
import nl.tudelft.simulation.traffic.vehicle.VehicleType;
import nl.tudelft.simulation.xml.AbstractXMLParser;
import nl.tudelft.simulation.xml.language.ColorParser;
import nl.tudelft.simulation.xml.language.LocationParser;
import org.jdom.Element;

public class InfraFileXMLParser
extends AbstractXMLParser {
    public static final URL INFRAFILE_SCHEMA = URLResource.getResource((String)"/infrafile.xsd");
    private HashMap linkMap = new HashMap();
    private HashMap trackMap = new HashMap();
    private HashMap vehicleTypeMap = new HashMap();
    private DEVSSimulatorInterface simulator;
    private double railwidth = 1.48;
    private static StreamInterface stream = new Java2Random();

    public InfraFileXMLParser(URL url, URL schema, String schemaNamespace, boolean validateSchema, DEVSSimulatorInterface simulator) throws Exception {
        super(url, schema, schemaNamespace, validateSchema);
        this.simulator = simulator;
        Element rootElement = this.parse();
        this.parse(rootElement);
    }

    public InfraFileXMLParser(URL url, URL schema, String schemaNamespace, boolean validateSchema, DEVSSimulatorInterface simulator, HashMap linkMap, HashMap trackMap) throws Exception {
        super(url, schema, schemaNamespace, validateSchema);
        this.simulator = simulator;
        this.linkMap = new HashMap(linkMap);
        this.trackMap = new HashMap(trackMap);
        Element rootElement = this.parse();
        this.parse(rootElement);
    }

    protected void parse(Element xmlMapFileElement) throws Exception {
        Element vehicleTypes;
        Iterator iterator;
        Iterator iterator2;
        Iterator iterator3;
        Element signals;
        Element links = xmlMapFileElement.getChild("links");
        if (links == null) {
            System.err.println("links element not found...");
        } else {
            List linkElements = links.getChildren("link");
            Iterator iterator4 = linkElements.iterator();
            while (iterator4.hasNext()) {
                Element linkElement = (Element)iterator4.next();
                this.parseLink(linkElement);
            }
        }
        Element tracks = xmlMapFileElement.getChild("tracks");
        if (tracks == null) {
            System.err.println("tracks element not found...");
        } else {
            List trackElements = tracks.getChildren("track");
            Iterator iterator5 = trackElements.iterator();
            while (iterator5.hasNext()) {
                Element trackElement = (Element)iterator5.next();
                this.parseTrack(trackElement).toString();
            }
        }
        Element successors = xmlMapFileElement.getChild("activeSuccessors");
        if (successors == null) {
            System.err.println("activeSuccessors element not found...");
        } else {
            List successorElements = successors.getChildren("successor");
            Iterator iterator6 = successorElements.iterator();
            while (iterator6.hasNext()) {
                Element successorElement = (Element)iterator6.next();
                this.parseSuccessor(successorElement);
            }
        }
        Element stations = xmlMapFileElement.getChild("stations");
        if (stations != null) {
            List stationElements = stations.getChildren("station");
            Iterator iterator7 = stationElements.iterator();
            while (iterator7.hasNext()) {
                Element stationElement = (Element)iterator7.next();
                this.parseStation(stationElement);
            }
        }
        if ((signals = xmlMapFileElement.getChild("signals")) != null) {
            List speedSignElements = signals.getChildren("speedSign");
            Iterator iterator8 = speedSignElements.iterator();
            while (iterator8.hasNext()) {
                Element speedSignElement = (Element)iterator8.next();
                this.parseSpeedSign(speedSignElement);
            }
            List trafficLightRandomElements = signals.getChildren("trafficLightRandom");
            iterator3 = trafficLightRandomElements.iterator();
            while (iterator3.hasNext()) {
                Element trafficLightRandomElement = (Element)iterator3.next();
                this.parseTrafficLightRandom(trafficLightRandomElement);
            }
            List blockTrafficLightElements = signals.getChildren("blockTrafficLight");
            iterator2 = blockTrafficLightElements.iterator();
            while (iterator2.hasNext()) {
                Element blockTrafficLightElement = (Element)iterator2.next();
                this.parseBlockTrafficLight(blockTrafficLightElement);
            }
            List switchBlockElements = signals.getChildren("switchBlock");
            iterator = switchBlockElements.iterator();
            while (iterator.hasNext()) {
                Element switchBlockElement = (Element)iterator.next();
                this.parseSwitchBlock(switchBlockElement);
            }
        }
        if ((vehicleTypes = xmlMapFileElement.getChild("vehicleTypes")) == null) {
            System.err.println("vehicleTypes element not found...");
        } else {
            List vehicleTypesElements = vehicleTypes.getChildren("vehicleType");
            iterator3 = vehicleTypesElements.iterator();
            while (iterator3.hasNext()) {
                Element vehicleTypeElement = (Element)iterator3.next();
                this.parseVehicleType(vehicleTypeElement);
            }
        }
        Element genVehicles = xmlMapFileElement.getChild("genVehicles");
        if (genVehicles == null) {
            System.out.println("genVehicles element not found...");
        } else {
            List genVehiclesElements = genVehicles.getChildren("genVehicle");
            iterator2 = genVehiclesElements.iterator();
            while (iterator2.hasNext()) {
                Element genVehicleElement = (Element)iterator2.next();
                this.parseGenVehicle(genVehicleElement);
            }
            List delVehiclesElements = genVehicles.getChildren("delVehicle");
            iterator = delVehiclesElements.iterator();
            while (iterator.hasNext()) {
                Element delVehicleElement = (Element)iterator.next();
                this.parseDelVehicle(delVehicleElement);
            }
        }
    }

    private Point2D parseAnimationOffset(Element element) throws IOException {
        try {
            double dx = new Double(element.getChildText("dx"));
            double dy = new Double(element.getChildText("dy"));
            return new Point2D.Double(dx, dy);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private double parseTimeUnit(Element element) throws IOException {
        try {
            double value = new Double(element.getChildText("value"));
            String unit = element.getChildText("unit");
            if ("second".equals(unit)) {
                return TimeUnit.convert((double)value, (TimeUnitInterface)TimeUnitInterface.SECOND, (SimulatorInterface)this.simulator);
            }
            if ("minute".equals(unit)) {
                return TimeUnit.convert((double)value, (TimeUnitInterface)TimeUnitInterface.MINUTE, (SimulatorInterface)this.simulator);
            }
            if ("hour".equals(unit)) {
                return TimeUnit.convert((double)value, (TimeUnitInterface)TimeUnitInterface.HOUR, (SimulatorInterface)this.simulator);
            }
            throw new Exception("Unknown time unit " + unit);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private double parseSpeedUnit(Element element) throws IOException {
        try {
            double value = new Double(element.getChildText("value"));
            String unit = element.getChildText("unit");
            if ("mps".equals(unit)) {
                return value / TimeUnit.convert((double)1.0, (TimeUnitInterface)TimeUnitInterface.SECOND, (SimulatorInterface)this.simulator);
            }
            if ("kmph".equals(unit)) {
                return 1000.0 * value / TimeUnit.convert((double)1.0, (TimeUnitInterface)TimeUnitInterface.HOUR, (SimulatorInterface)this.simulator);
            }
            throw new Exception("Unknown speed unit " + unit);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private DistContinuous parseContinuousTimeDistribution(Element element) throws IOException {
        try {
            String streamId = element.getChildText("stream");
            StreamInterface stream = this.simulator.getReplication().getStream(streamId);
            if (stream == null) {
                stream = new Java2Random();
            }
            if (element.getChild("triangular") != null) {
                Element distribution = element.getChild("triangular");
                double a = new Double(this.parseTimeUnit(distribution.getChild("a")));
                double b = new Double(this.parseTimeUnit(distribution.getChild("b")));
                double c = new Double(this.parseTimeUnit(distribution.getChild("c")));
                return new DistTriangular(stream, a, b, c);
            }
            if (element.getChild("normal") != null) {
                Element distribution = element.getChild("normal");
                double mean = new Double(this.parseTimeUnit(distribution.getChild("mean")));
                double stdev = new Double(this.parseTimeUnit(distribution.getChild("stdev")));
                return new DistNormal(stream, mean, stdev);
            }
            if (element.getChild("exponential") != null) {
                Element distribution = element.getChild("exponential");
                double lambda = new Double(this.parseTimeUnit(distribution.getChild("lambda")));
                return new DistExponential(stream, lambda);
            }
            if (element.getChild("constant") != null) {
                Element distribution = element.getChild("constant");
                double c = new Double(this.parseTimeUnit(distribution.getChild("c")));
                return new DistConstant(stream, c);
            }
            throw new Exception("Unknown distribution in " + element.getName());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private TrackLinkInterface parseLink(Element element) throws IOException {
        DirectedPoint location = new DirectedPoint();
        String name = "";
        try {
            name = element.getChildText("name");
            location = LocationParser.parseLocation((Element)element.getChild("location"));
            boolean simple = "simple".equals(element.getChildText("type"));
            DirectedPoint link = simple ? new SimpleTrackLink(name, location) : new ComplexTrackLink(name, location);
            this.linkMap.put(name, link);
            Logger.finer((Object)((Object)this), (String)"parseLink", (String)link.toString());
            return link;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private TrackInterface parseTrack(Element element) throws IOException {
        try {
            String name = element.getChildText("name");
            String startLinkString = element.getChildText("startLink");
            TrackLinkInterface startLink = (TrackLinkInterface)this.linkMap.get(startLinkString);
            if (startLink == null) {
                throw new Exception("Track " + name + ": start link " + startLinkString + " not defined");
            }
            String endLinkString = element.getChildText("endLink");
            TrackLinkInterface endLink = (TrackLinkInterface)this.linkMap.get(endLinkString);
            if (endLink == null) {
                throw new Exception("Track " + name + ": end link " + endLinkString + " not defined");
            }
            String type = element.getChildText("type");
            if ("straight".equals(type)) {
                StraightTrack track = new StraightTrack(name, startLink, endLink);
                new StraightTrackAnimation(track, (SimulatorInterface)this.simulator, this.railwidth);
                this.trackMap.put(name, track);
                Logger.finer((Object)((Object)this), (String)"parseTrack[straight]", (String)((Object)track).toString());
                return track;
            }
            if ("arc".equals(type)) {
                double radius = new Double(element.getChildText("radius"));
                ArcTrack track = new ArcTrack(name, startLink, endLink, radius);
                new ArcTrackAnimation(track, (SimulatorInterface)this.simulator, this.railwidth);
                this.trackMap.put(name, track);
                Logger.finer((Object)((Object)this), (String)"parseTrack[arc]", (String)track.toString());
                return track;
            }
            if ("virtual".equals(type)) {
                VirtualTrack track = new VirtualTrack(name, startLink, endLink);
                this.trackMap.put(name, track);
                Logger.finer((Object)((Object)this), (String)"parseTrack[virtual]", (String)((Object)track).toString());
                return track;
            }
            throw new Exception("Track " + name + ": type " + type + " not supported yet");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private void parseSuccessor(Element element) throws IOException {
        try {
            String linkString = element.getChildText("link");
            TrackLinkInterface link = (TrackLinkInterface)this.linkMap.get(linkString);
            if (link == null) {
                throw new Exception("Successor: link " + link + " not defined");
            }
            String startTrackString = element.getChildText("startTrack");
            TrackInterface startTrack = (TrackInterface)this.trackMap.get(startTrackString);
            if (startTrack == null) {
                throw new Exception("Successor: start track " + startTrackString + " not defined");
            }
            if (!link.equals(startTrack.getEndLink())) {
                throw new Exception("Successor: link " + link + " not the end link of track " + startTrackString);
            }
            String nextTrackString = element.getChildText("nextTrack");
            TrackInterface nextTrack = (TrackInterface)this.trackMap.get(nextTrackString);
            if (nextTrack == null) {
                throw new Exception("Successor: next track " + nextTrackString + " not defined");
            }
            if (!link.equals(nextTrack.getStartLink())) {
                throw new Exception("Successor: link " + link + " not the start link of track " + nextTrackString);
            }
            boolean active = Boolean.valueOf(element.getChildText("active"));
            startTrack.getEndLink().setActiveSuccessor(startTrack, nextTrack);
            Logger.finer((Object)((Object)this), (String)"parseSuccessor", (String)(String.valueOf(startTrack.toString()) + "-" + nextTrack.toString()));
            if (active) {
                link.setActiveSuccessor(startTrack, nextTrack);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private TrackProgression correctedTrackProgression(TrackInterface track, double progression) {
        List tpl = track.calculateTrackProgressionListAll(progression);
        if (tpl.size() == 1) {
            return (TrackProgression)tpl.get(0);
        }
        Logger.severe((Object)((Object)this), (String)"correctedTrackProgression", (String)("not one corrected location for track " + track + ", progression " + progression));
        System.out.println();
        return new TrackProgression(track, progression);
    }

    private void parseStation(Element element) throws IOException {
        try {
            String stationName = element.getChildText("stationName");
            String stationCode = element.getChildText("stationCode");
            String stationCompanyCode = element.getChildText("stationCompanyCode");
            String startTrackString = element.getChildText("startTrack");
            TrackInterface startTrack = (TrackInterface)this.trackMap.get(startTrackString);
            if (startTrack == null) {
                throw new Exception("Station: start track " + startTrackString + "not defined");
            }
            double stationProgression = new Double(element.getChildText("progression"));
            TrackProgression tp = this.correctedTrackProgression(startTrack, stationProgression);
            double requestDistance = new Double(element.getChildText("requestDistance"));
            double stationLength = new Double(element.getChildText("stationLength"));
            double stoppingPlaceLength = new Double(element.getChildText("stoppingPlaceLength"));
            double haltingTime = new Double(element.getChildText("haltingTime"));
            String platformSide = element.getChildText("platformSide");
            new Station(stationName, stationCode, stationCompanyCode, tp.getTrack(), tp.getProgression(), requestDistance, stationLength, stoppingPlaceLength, TimeUnit.convert((double)haltingTime, (TimeUnitInterface)TimeUnitInterface.SECOND, (SimulatorInterface)this.simulator), platformSide, this.simulator);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private void parseSpeedSign(Element element) throws IOException {
        try {
            String name = element.getChildText("name");
            String trackString = element.getChildText("track");
            TrackInterface track = (TrackInterface)this.trackMap.get(trackString);
            if (track == null) {
                throw new Exception("parseSpeedSign : track " + trackString + " not defined");
            }
            double progression = new Double(element.getChildText("progression"));
            TrackProgression tp = this.correctedTrackProgression(track, progression);
            double visibleDistance = new Double(element.getChildText("visibleDistance"));
            Element speedLimit = element.getChild("speedLimit");
            double speedLimitValue = this.parseSpeedUnit(speedLimit);
            String speedLimitText = speedLimit.getChildText("text");
            Point2D animationOffset = this.parseAnimationOffset(element.getChild("animationOffset"));
            Color backgroundColor = ColorParser.parseColor((Element)element.getChild("backgroundColor"));
            Color textColor = ColorParser.parseColor((Element)element.getChild("textColor"));
            Color lineColor = ColorParser.parseColor((Element)element.getChild("lineColor"));
            new SpeedSign(name, tp.getTrack(), tp.getProgression(), visibleDistance, speedLimitValue, (SimulatorInterface)this.simulator, animationOffset.getX(), animationOffset.getY(), speedLimitText, backgroundColor, textColor, lineColor);
            Logger.finer((Object)((Object)this), (String)"parseSpeedSign", (String)(String.valueOf(track.toString()) + ":" + name));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private void parseTrafficLightRandom(Element element) throws IOException {
        try {
            String name = element.getChildText("name");
            String trackString = element.getChildText("track");
            TrackInterface track = (TrackInterface)this.trackMap.get(trackString);
            if (track == null) {
                throw new Exception("parseTrafficLightRandom : track " + trackString + " not defined");
            }
            double progression = new Double(element.getChildText("progression"));
            TrackProgression tp = this.correctedTrackProgression(track, progression);
            double visibleDistance = new Double(element.getChildText("visibleDistance"));
            double timeGreen = new Double(element.getChildText("timeGreen"));
            double timeRed = new Double(element.getChildText("timeRed"));
            boolean initialGreen = Boolean.valueOf(element.getChildText("initialGreen"));
            String status = initialGreen ? "CONT" : "STOP";
            Point2D animationOffset = this.parseAnimationOffset(element.getChild("animationOffset"));
            new TrafficLight(name, tp.getProgression(), visibleDistance, tp.getTrack(), (DistContinuous)new DistExponential(stream, timeGreen), (DistContinuous)new DistExponential(stream, timeRed), status, this.simulator, animationOffset.getX(), animationOffset.getY());
            Logger.finer((Object)((Object)this), (String)"parseTrafficLightRandom", (String)(String.valueOf(track.toString()) + ":" + name));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private void parseBlockTrafficLight(Element element) throws IOException {
        try {
            String name = element.getChildText("name");
            String trackString = element.getChildText("track");
            TrackInterface track = (TrackInterface)this.trackMap.get(trackString);
            if (track == null) {
                throw new Exception("parseBlockTrafficLight : track " + trackString + " not defined");
            }
            double progression = new Double(element.getChildText("progression"));
            TrackProgression tp = this.correctedTrackProgression(track, progression);
            double visibleDistance = new Double(element.getChildText("visibleDistance"));
            double distanceRed = new Double(element.getChildText("distanceRed"));
            double distanceYellow = new Double(element.getChildText("distanceYellow"));
            double distanceGreen = new Double(element.getChildText("distanceGreen"));
            Point2D animationOffset = this.parseAnimationOffset(element.getChild("animationOffset"));
            new BlockTrafficLight(name, tp.getTrack(), tp.getProgression(), visibleDistance, distanceRed, distanceYellow, distanceGreen, this.simulator, animationOffset.getX(), animationOffset.getY());
            Logger.finer((Object)((Object)this), (String)"parseBlockTrafficLight", (String)(String.valueOf(track.toString()) + ":" + name));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private void parseSwitchBlock(Element element) throws IOException {
        try {
            String name = element.getChildText("name");
            DistContinuous switchTime = this.parseContinuousTimeDistribution(element.getChild("switchTime"));
            System.out.println("switchBlock = " + name + " switchTime = " + switchTime);
            VirtualSwitchBlock switchBlock = new VirtualSwitchBlock(name, this.simulator, switchTime);
            List switchBlockTrafficLightElements = element.getChildren("switchBlockTrafficLight");
            Iterator iterator = switchBlockTrafficLightElements.iterator();
            while (iterator.hasNext()) {
                Element switchBlockTrafficLightElement = (Element)iterator.next();
                this.parseSwitchBlockTrafficLight(switchBlock, switchBlockTrafficLightElement);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private void parseSwitchBlockTrafficLight(VirtualSwitchBlock switchBlock, Element element) throws IOException {
        try {
            String name = element.getChildText("name");
            String trackString = element.getChildText("track");
            TrackInterface track = (TrackInterface)this.trackMap.get(trackString);
            if (track == null) {
                throw new Exception("parseSwitchBlockTrafficLight : track " + trackString + " not defined");
            }
            double progression = new Double(element.getChildText("progression"));
            TrackProgression tp = this.correctedTrackProgression(track, progression);
            double visibleDistance = new Double(element.getChildText("visibleDistance"));
            double distanceRequest = new Double(element.getChildText("distanceRequest"));
            double distanceRed = new Double(element.getChildText("distanceRed"));
            Point2D animationOffset = this.parseAnimationOffset(element.getChild("animationOffset"));
            SwitchBlockTrafficLight sbtl = new SwitchBlockTrafficLight(name, tp.getTrack(), tp.getProgression(), switchBlock, visibleDistance, distanceRequest, distanceRed, this.simulator, animationOffset.getX(), animationOffset.getY());
            Element switchSettings = element.getChild("switchSettings");
            List switchSettingsElements = switchSettings.getChildren("switchSetting");
            if (switchSettingsElements != null) {
                Iterator iterator = switchSettingsElements.iterator();
                while (iterator.hasNext()) {
                    Element switchSettingElement = (Element)iterator.next();
                    this.parseSwitchSetting(sbtl, switchSettingElement);
                }
            }
            Logger.finer((Object)((Object)this), (String)"parseSwitchBlockTrafficLight", (String)(String.valueOf(track.toString()) + ":" + name));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private void parseSwitchSetting(SwitchBlockTrafficLight sbtl, Element element) throws IOException {
        try {
            Element successor;
            String fromTrackStr;
            TrackInterface fromTrack;
            Element linesElement = element.getChild("lines");
            List lineElementList = linesElement.getChildren("line");
            ArrayList<String> lineList = new ArrayList<String>();
            if (lineElementList != null) {
                Iterator iterator = lineElementList.iterator();
                while (iterator.hasNext()) {
                    String lineText = ((Element)iterator.next()).getText();
                    System.out.println("parser line: " + lineText);
                    lineList.add(lineText);
                }
            }
            if ((fromTrack = (TrackInterface)this.trackMap.get(fromTrackStr = (successor = element.getChild("successor")).getChildText("fromTrack"))) == null) {
                throw new Exception("parseSwitchSetting: fromTrack " + fromTrackStr + " not defined");
            }
            TrackLinkInterface link = fromTrack.getEndLink();
            String toTrackStr = successor.getChildText("toTrack");
            TrackInterface toTrack = (TrackInterface)this.trackMap.get(toTrackStr);
            if (toTrack == null) {
                throw new Exception("parseSwitchSetting: toTrack " + toTrackStr + " not defined");
            }
            if (!link.equals(toTrack.getStartLink())) {
                throw new Exception("parseSwitchSetting: link " + link + " not the start link of track " + toTrackStr);
            }
            double distanceRelease = new Double(element.getChildText("distanceRelease"));
            System.out.println("parser distanceRelease: " + distanceRelease);
            ((VirtualSwitchBlock)sbtl.getVirtualBlock()).addSwitchDirection(sbtl, lineList, distanceRelease, fromTrack, toTrack);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private VehicleType parseVehicleType(Element element) throws IOException {
        String name = "";
        try {
            VehicleType vehicleType = new VehicleType();
            name = element.getChildText("name");
            vehicleType.setName(name);
            vehicleType.setLength(new Double(element.getChildText("length")));
            vehicleType.setWidth(new Double(element.getChildText("width")));
            double maxSpeed = new Double(element.getChildText("maxSpeed"));
            vehicleType.setVehicleMaximumSpeed(maxSpeed);
            AccelerationProfile accProfile = new AccelerationProfile(maxSpeed);
            List accElements = element.getChildren("acceleration");
            Iterator iterator = accElements.iterator();
            while (iterator.hasNext()) {
                Element accElement = (Element)iterator.next();
                double speed = new Double(accElement.getChildText("speed"));
                double acc = new Double(accElement.getChildText("acc"));
                accProfile.setAccelerationFromSpeed(speed, acc);
            }
            vehicleType.setAccelerationProfile(accProfile);
            DecelerationProfile decProfile = new DecelerationProfile(maxSpeed);
            List decElements = element.getChildren("deceleration");
            Iterator iterator2 = decElements.iterator();
            while (iterator2.hasNext()) {
                Element decElement = (Element)iterator2.next();
                double speed = new Double(decElement.getChildText("speed"));
                double dec = new Double(decElement.getChildText("dec"));
                decProfile.setDecelerationFromSpeed(speed, dec);
            }
            vehicleType.setDecelerationProfile(decProfile);
            vehicleType.setColor(ColorParser.parseColor((Element)element.getChild("color")));
            Element segments = element.getChild("segments");
            if (segments != null) {
                List segmentsElements = segments.getChildren("segment");
                Iterator iterator3 = segmentsElements.iterator();
                while (iterator3.hasNext()) {
                    Element segmentElement = (Element)iterator3.next();
                    double front = new Double(segmentElement.getChildText("front"));
                    double axle1 = new Double(segmentElement.getChildText("axle1"));
                    double axle2 = new Double(segmentElement.getChildText("axle2"));
                    double length = new Double(segmentElement.getChildText("length"));
                    vehicleType.addSegment(front, axle1, axle2, length);
                }
            }
            this.vehicleTypeMap.put(name, vehicleType);
            Logger.finer((Object)((Object)this), (String)"parseVehicleType", (String)vehicleType.getName());
            System.out.println("parseVehicleType " + vehicleType.getName());
            return vehicleType;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private VehicleControlInterface parseVehicle(Element element) throws IOException {
        try {
            String type = element.getChildText("type");
            VehicleType vehicleType = (VehicleType)this.vehicleTypeMap.get(type);
            if (vehicleType == null) {
                throw new Exception("parseVehicle : vehicleType " + type + " not defined");
            }
            String trackString = element.getChildText("track");
            TrackInterface track = (TrackInterface)this.trackMap.get(trackString);
            if (track == null) {
                throw new Exception("parseVehicle : track " + trackString + " not defined");
            }
            double progression = new Double(element.getChildText("progression"));
            TrackProgression tp = this.correctedTrackProgression(track, progression);
            String line = element.getChildText("line");
            double maxSpeedStart = new Double(element.getChildText("maxSpeedStart"));
            Logger.finer((Object)((Object)this), (String)"parseVehicle", (String)(String.valueOf(vehicleType.getName()) + " track " + track));
            System.out.println("parseVehicle" + vehicleType.getName() + " track " + track);
            VehicleControl vehicleControl = new VehicleControl(line);
            VehiclePhysical vehiclePhysical = new VehiclePhysical(vehicleType, vehicleControl, tp.getTrack(), tp.getProgression(), maxSpeedStart, (DEVDESSSimulatorInterface)this.simulator);
            vehiclePhysical.setVehicleControl(vehicleControl);
            vehicleControl.setVehiclePhysical(vehiclePhysical);
            this.simulator.scheduleEvent(0.0, (Object)this, (Object)vehicleControl, "startDriving", new Object[0]);
            return vehicleControl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    private void parseGenVehicle(Element element) throws IOException {
        try {
            String type = element.getChildText("type");
            VehicleType vehicleType = (VehicleType)this.vehicleTypeMap.get(type);
            if (vehicleType == null) {
                throw new Exception("parseGenVehicle : vehicleType " + type + " not defined");
            }
            String trackString = element.getChildText("track");
            TrackInterface track = (TrackInterface)this.trackMap.get(trackString);
            if (track == null) {
                throw new Exception("parseGenVehicle : track " + trackString + " not defined");
            }
            double progression = new Double(element.getChildText("progression"));
            TrackProgression tp = this.correctedTrackProgression(track, progression);
            double firstGen = this.parseTimeUnit(element.getChild("firstGen"));
            double interval = this.parseTimeUnit(element.getChild("interval"));
            String line = element.getChildText("line");
            double maxSpeedStart = new Double(element.getChildText("maxSpeedStart"));
            Logger.finer((Object)((Object)this), (String)"parseGenVehicle", (String)(String.valueOf(vehicleType.getName()) + " track " + tp));
            System.out.println("parseGenVehicle" + vehicleType.getName() + " track " + tp);
            Object[] args = new Object[]{tp.getTrack(), new Double(tp.getProgression()), new Double(maxSpeedStart), vehicleType, new Double(interval), line};
            this.simulator.scheduleEvent(firstGen, (Object)this, (Object)this, "genVehicle", args);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    protected void genVehicle(TrackInterface track, double progression, double maxSpeedStart, VehicleType vehicleType, double interval, String line) throws Exception {
        try {
            VehicleControl vehicleControl = new VehicleControl(line);
            VehiclePhysical vehiclePhysical = new VehiclePhysical(vehicleType, vehicleControl, track, progression, maxSpeedStart, (DEVDESSSimulatorInterface)this.simulator);
            vehicleControl.setVehiclePhysical(vehiclePhysical);
            vehicleControl.startDriving();
            Object[] args = new Object[]{track, new Double(progression), new Double(maxSpeedStart), vehicleType, new Double(interval), line};
            this.simulator.scheduleEvent(interval, (Object)this, (Object)this, "genVehicle", args);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage());
        }
    }

    private void parseDelVehicle(Element element) throws IOException {
        try {
            String trackString = element.getChildText("track");
            TrackInterface track = (TrackInterface)this.trackMap.get(trackString);
            if (track == null) {
                throw new Exception("parseDelVehicle : track " + trackString + " not defined");
            }
            double progression = new Double(element.getChildText("progression"));
            TrackProgression tp = this.correctedTrackProgression(track, progression);
            new RemoveControlPoint(tp.getTrack(), tp.getProgression(), (SimulatorInterface)this.simulator);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }
}

