/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.station;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.animation.StationAnimation;
import nl.tudelft.simulation.traffic.station.StoppingPlace;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;

public class Station
implements LocatableInterface {
    private String name;
    private String stationCode;
    private String stationCompanyCode;
    private TrackInterface startTrack;
    private double progression;
    private double stationLength;
    private double requestDistance;
    private List stoppingPlacesList = new ArrayList();
    public static final String PLATFORM_LEFT = "LEFT";
    public static final String PLATFORM_RIGHT = "RIGHT";
    public String platformSide;
    private double haltingTime;
    private DirectedPoint location = new DirectedPoint();

    public Station(String name, String stationCode, String stationCompanyCode, TrackInterface startTrack, double stationProgression, double requestDistance, double stationLength, double stoppingPlaceLength, double haltingTime, String platformSide, DEVSSimulatorInterface simulator) {
        this.name = name;
        this.stationCode = stationCode;
        this.stationCompanyCode = stationCompanyCode;
        TrackProgression tp = startTrack.calculateTrackProgressionListActive(stationProgression);
        if (tp == null) {
            System.err.println("NO TRACK / PROGRESSION FOR STATION " + name + ", track: " + startTrack + "." + stationProgression);
            return;
        }
        this.startTrack = tp.getTrack();
        this.progression = tp.getProgression();
        this.requestDistance = requestDistance;
        this.stationLength = stationLength;
        this.haltingTime = haltingTime;
        this.platformSide = platformSide;
        double startLength = 0.0;
        while (startLength < stationLength) {
            StoppingPlace stoppingPlace = new StoppingPlace(this, this.startTrack, this.progression - startLength, this.requestDistance, stoppingPlaceLength, simulator);
            this.addStoppingPlace(stoppingPlace);
            startLength += stoppingPlaceLength;
        }
        DirectedPoint p = this.startTrack.getLocationOfProgression(this.progression);
        DirectedPoint q = this.startTrack.getLocationOfProgression(this.progression - this.stationLength);
        double dx = q.x - p.x;
        double dy = q.y - p.y;
        double alpha = Math.atan2(dy, dx);
        double beta = this.platformSide.equals(PLATFORM_LEFT) ? alpha - 1.5707963267948966 : alpha + 1.5707963267948966;
        double d = 3.0;
        this.location = new DirectedPoint(p.x + d * Math.cos(beta), p.y + d * Math.sin(beta), p.z, 0.0, 0.0, alpha);
        if (simulator instanceof AnimatorInterface) {
            new StationAnimation(this, (SimulatorInterface)simulator);
        }
    }

    public StoppingPlace getAccessibleStoppingPlace(List stoppingPlacesList) {
        boolean found = false;
        int i = stoppingPlacesList.size() - 1;
        while (i >= 0 && !found) {
            StoppingPlace place = (StoppingPlace)stoppingPlacesList.get(i);
            if (place.isClaimed()) {
                found = true;
                break;
            }
            --i;
        }
        if (i == stoppingPlacesList.size() - 1 && found) {
            return null;
        }
        return (StoppingPlace)stoppingPlacesList.get(i++);
    }

    private void addStoppingPlace(StoppingPlace stoppingPlace) {
        this.stoppingPlacesList.add(stoppingPlace);
    }

    public String getName() {
        return this.name;
    }

    public double getStationLength() {
        return this.stationLength;
    }

    public double getProgression() {
        return this.progression;
    }

    public TrackInterface getStartTrack() {
        return this.startTrack;
    }

    public List getStoppingPlacesList() {
        return this.stoppingPlacesList;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public String getStationCompanyCode() {
        return this.stationCompanyCode;
    }

    public String getPlatformSide() {
        return this.platformSide;
    }

    public double getHaltingTime() {
        return this.haltingTime;
    }

    public DirectedPoint getLocation() throws RemoteException {
        return this.location;
    }

    public Bounds getBounds() throws RemoteException {
        DirectedPoint p = this.location;
        DirectedPoint q = this.startTrack.getLocationOfProgression(this.progression + this.stationLength);
        return new BoundingBox(new Point3d(0.0, 0.0, 0.0), new Point3d(q.x - p.x, q.y - p.y, 0.0));
    }
}

