/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.station;

import java.rmi.RemoteException;
import java.util.List;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.event.Event;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.animation.StationLightAnimation;
import nl.tudelft.simulation.traffic.controlpoint.real.AbstractVisibleControlPoint;
import nl.tudelft.simulation.traffic.controlpoint.real.Changeable;
import nl.tudelft.simulation.traffic.controlpoint.real.StopSignInterface;
import nl.tudelft.simulation.traffic.station.Station;
import nl.tudelft.simulation.traffic.station.StationControlPoint;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.util.TrackProgression;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class StationHaltingTrafficLight
extends AbstractVisibleControlPoint
implements LocatableInterface,
StopSignInterface {
    public static final String STATE_GREEN = "GREEN";
    public static final String STATE_RED = "RED";
    public static final int SENSOR_RED = 0;
    public static final int SENSOR_TIMER = 1;
    public static final String[] sensorNames = new String[]{"RED", "TIMER"};
    public double requestDistance;
    private String currentState = "GREEN";
    private String name;
    private double dx;
    private double dy;
    public Station station;
    public DEVSSimulatorInterface simulator;

    public StationHaltingTrafficLight(Station station, String name, TrackInterface track, double progression, double visibleDistance, double requestDistance, DEVSSimulatorInterface simulator, double dx, double dy) {
        super(track, progression, visibleDistance, (SimulatorInterface)simulator);
        this.name = name;
        this.station = station;
        System.out.println(this + ", placed on " + this.track + " progression " + this.progression + " (length=" + this.track.getLength() + ")");
        this.requestDistance = requestDistance;
        double vcpProg = progression - requestDistance;
        this.addStationSensors(this.track, vcpProg, 0, (SimulatorInterface)simulator);
        vcpProg = progression - 1.0;
        this.addStationSensors(this.track, vcpProg, 1, (SimulatorInterface)simulator);
        this.simulator = simulator;
        this.dx = dx;
        this.dy = dy;
        if (simulator instanceof AnimatorInterface) {
            new StationLightAnimation(this, (SimulatorInterface)simulator, dx, dy);
        }
    }

    private void addStationSensors(TrackInterface track, double vcpProg, int sensor, SimulatorInterface simulator) {
        List tpList = track.calculateTrackProgressionListAll(vcpProg);
        int i = 0;
        while (i < tpList.size()) {
            TrackProgression tp = (TrackProgression)tpList.get(i);
            new StationControlPoint(tp.getTrack(), tp.getProgression(), this, sensor, simulator);
            System.out.println(this + ", sensor " + sensorNames[sensor] + " added on track " + tp.getTrack() + ", progression " + tp.getProgression());
            ++i;
        }
    }

    public void triggerSensor(int sensor, VehiclePhysicalInterface vehicle) {
        Logger.fine((Object)this, (String)"triggerSensor", (String)(this + ", Vehicle " + vehicle.toString() + " triggered sensor " + sensorNames[sensor] + ", old state was " + this.currentState));
        System.out.println(this + ", Vehicle " + vehicle.toString() + " triggered sensor " + sensorNames[sensor] + ", old state was " + this.currentState);
        switch (sensor) {
            case 0: {
                this.currentState = STATE_RED;
                break;
            }
            case 1: {
                System.out.println("station.getHaltingTime: " + this.station.getHaltingTime());
                try {
                    this.simulator.scheduleEvent(this.station.getHaltingTime(), (Object)this, (Object)this, "stateGreen", null);
                }
                catch (Exception e) {
                    Logger.severe((Object)this, (String)"triggerSensor", (Throwable)e);
                }
                break;
            }
            default: {
                Logger.severe((Object)this, (String)"triggerSensor", (String)"reported state not RED or TIMER");
            }
        }
        Logger.fine((Object)this, (String)"triggerSensor", (String)(this + ", Vehicle " + vehicle.toString() + " new state is " + this.currentState));
        System.out.println(this + ", Vehicle " + vehicle.toString() + " new state is " + this.currentState);
        Event event = new Event(Changeable.CHANGE_STATUS_EVENT, (Object)this, null);
        this.fireEvent((EventInterface)event);
    }

    public void stateGreen() {
        System.out.println("TIMER state turned to GREEN");
        this.currentState = STATE_GREEN;
        Event event = new Event(Changeable.CHANGE_STATUS_EVENT, (Object)this, null);
        this.fireEvent((EventInterface)event);
    }

    public void pass(VehiclePhysicalInterface vehicle) {
        this.removeListener(vehicle, Changeable.CHANGE_STATUS_EVENT);
    }

    public DirectedPoint getLocation() throws RemoteException {
        DirectedPoint p = super.getTrack().getLocationOfProgression(super.getProgression());
        return new DirectedPoint(p.x, p.y, p.z);
    }

    public Bounds getBounds() throws RemoteException {
        return new BoundingBox(new Point3d(this.dx - 2.0, this.dy, 0.0), new Point3d(this.dx + 2.0, this.dy + 12.0, 0.0));
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public String getStatus() {
        if (this.currentState == STATE_RED) {
            return "STOP";
        }
        return "CONT";
    }

    public String toString() {
        return "StationHaltingTrafficLight " + this.name;
    }

    public Station getStation() {
        return this.station;
    }
}

