/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.station;

import nl.tudelft.simulation.dsol.simulators.DEVSSimulatorInterface;
import nl.tudelft.simulation.traffic.controlpoint.blocks.BlockTrafficLight;
import nl.tudelft.simulation.traffic.station.Station;
import nl.tudelft.simulation.traffic.station.StationHaltingTrafficLight;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.vehicle.VehiclePhysicalInterface;

public class StoppingPlace {
    private double progression;
    private double length;
    private boolean claimed = false;
    private Station station;
    private TrackInterface startTrack;
    private BlockTrafficLight callBack;
    private int sensor;

    public StoppingPlace(Station station, TrackInterface track, double progression, double requestDistance, double length, DEVSSimulatorInterface simulator) {
        this.station = station;
        this.startTrack = track;
        this.progression = progression;
        this.length = length;
        new StationHaltingTrafficLight(this.station, this.station.getName(), this.startTrack, this.progression, requestDistance + 5.0, requestDistance, simulator, 0.0, 10.0);
    }

    public boolean claimStoppingPlace() {
        if (this.claimed) {
            return false;
        }
        this.setClaimed(true);
        return true;
    }

    public void releaseStoppingPlace() {
        if (!this.isClaimed()) {
            System.out.print("WARNING: stopping place of the progression" + this.getProgression() + " is already available");
        } else {
            this.setClaimed(false);
            System.out.print("stopping place of progression" + this.progression + " is now set as available");
        }
    }

    public void pass(VehiclePhysicalInterface vehicle) {
        this.callBack.triggerSensor(this.sensor, vehicle);
        this.setClaimed(false);
    }

    public Station getStation() {
        return this.station;
    }

    public boolean isClaimed() {
        return this.claimed;
    }

    public double getLength() {
        return this.length;
    }

    public double getProgression() {
        return this.progression;
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    public TrackInterface getStartTrack() {
        return this.startTrack;
    }
}

