/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.track;

import java.rmi.RemoteException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.traffic.track.TrackInterface;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;
import nl.tudelft.simulation.traffic.track.util.TrackList;

public class SimpleTrackLink
extends DirectedPoint
implements TrackLinkInterface {
    private String name;
    private TrackInterface predecessor = null;
    private TrackInterface successor = null;

    public SimpleTrackLink(String name, DirectedPoint location) {
        super(location);
        this.name = name;
    }

    public SimpleTrackLink(String name, Point3d point) {
        super(point);
        this.name = name;
    }

    public SimpleTrackLink(String name, double x, double y, double z) {
        super(x, y, z);
        this.name = name;
    }

    public void addSuccessor(TrackInterface successor) {
        if (this.successor != null) {
            Logger.warning((Object)this, (String)"addSuccessor", (String)("Successor for " + this.name + " already defined as " + this.successor + ", while " + successor + " added"));
        }
        this.successor = successor;
    }

    public void addPredecessor(TrackInterface predecessor) {
        if (this.predecessor != null) {
            Logger.warning((Object)this, (String)"addPredecessor", (String)("Predecessor for " + this.name + " already defined as " + this.predecessor + ", while " + predecessor + " added"));
        }
        this.predecessor = predecessor;
    }

    public void setActiveSuccessor(TrackInterface predecessor, TrackInterface successor) {
        if (!predecessor.equals(this.predecessor)) {
            Logger.warning((Object)this, (String)"setActiveSuccessor", (String)("Predecessor " + predecessor + " for " + this.name + " not in list of predecessor"));
        }
        if (!successor.equals(this.successor)) {
            Logger.warning((Object)this, (String)"setActiveSuccessor", (String)("Active successor " + successor + " for " + this.name + " not in list of successors"));
        }
    }

    public TrackInterface getActiveSuccessor(TrackInterface predecessor) {
        if (!predecessor.equals(this.predecessor)) {
            Logger.warning((Object)this, (String)"getActiveSuccessor", (String)("Predecessor " + predecessor + " for " + this.name + " not in list of predecessors"));
        }
        return this.successor;
    }

    public TrackList getSuccessors() {
        TrackList trackList = new TrackList();
        trackList.add(this.successor);
        return trackList;
    }

    public TrackList getPredecessors() {
        TrackList trackList = new TrackList();
        trackList.add(this.predecessor);
        return trackList;
    }

    public Point3d getPosition() {
        return this;
    }

    public Bounds getBounds() {
        return new BoundingSphere((Point3d)this, 1.0);
    }

    public DirectedPoint getLocation() throws RemoteException {
        return this;
    }

    public String toString() {
        return this.name;
    }
}

