/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.track;

import javax.media.j3d.Bounds;
import javax.vecmath.Point3d;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;
import nl.tudelft.simulation.traffic.track.Track;
import nl.tudelft.simulation.traffic.track.TrackLinkInterface;

public class VirtualTrack
extends Track {
    public VirtualTrack(String name, TrackLinkInterface startLink, TrackLinkInterface endLink) throws Exception {
        super(name, startLink, endLink);
    }

    public DirectedPoint getLocationOfProgression(double progression) {
        double delta = progression / 1000.0;
        Point3d startPoint = this.startLink.getPosition();
        Point3d endPoint = this.endLink.getPosition();
        double x = startPoint.x + delta * (endPoint.x - startPoint.x);
        double y = startPoint.y + delta * (endPoint.y - startPoint.y);
        double z = startPoint.z + delta * (endPoint.z - startPoint.z);
        return new DirectedPoint(x, y, z, 0.0, 0.0, 0.0);
    }

    public Bounds getBounds() {
        return new BoundingBox();
    }

    public double getLength() {
        return 1000.0;
    }
}

