/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.vehicle;

import java.util.ArrayList;
import nl.tudelft.simulation.jstats.ode.DifferentialEquation;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;

public class AccelerationProfile {
    private ArrayList accdecList = new ArrayList();
    private double maxSpeed = 0.0;
    private boolean initialized = false;
    private Profile profile;
    protected static boolean debug = false;

    public AccelerationProfile(double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public void setAccelerationFromSpeed(double speed, double accdec) {
        this.accdecList.add(new AccDecPoint(speed, accdec));
        this.initialized = false;
    }

    public double getAcceleration(double speed) {
        double accdec = 0.0;
        int i = 0;
        while (i < this.accdecList.size()) {
            double adspeed = ((AccDecPoint)this.accdecList.get(i)).getSpeed();
            if (!(speed >= adspeed)) {
                return accdec;
            }
            accdec = ((AccDecPoint)this.accdecList.get(i)).getAccDec();
            ++i;
        }
        return accdec;
    }

    public void initializeProfile() {
        this.profile = new Profile(this, this.maxSpeed);
        this.initialized = true;
    }

    public double getAccelerationTime(double initialSpeed, double endSpeed) {
        if (!this.initialized) {
            this.initializeProfile();
        }
        return this.profile.getAccelerationTime(initialSpeed, endSpeed);
    }

    public double getAccelerationDistance(double initialSpeed, double endSpeed) {
        if (!this.initialized) {
            this.initializeProfile();
        }
        return this.profile.getAccelerationDistance(initialSpeed, endSpeed);
    }

    public static void main(String[] args) {
        try {
            AccelerationProfile dp = new AccelerationProfile(14.0);
            dp.setAccelerationFromSpeed(0.0, 1.0);
            dp.initializeProfile();
            System.out.println("Acceleration distance from 0.0 to 14.0 = " + dp.getAccelerationDistance(0.0, 14.0));
            System.out.println("Acceleration distance from 7.0 to 14.0 = " + dp.getAccelerationDistance(7.0, 14.0));
            System.out.println("Acceleration distance from  0.0 to 7.0 = " + dp.getAccelerationDistance(0.0, 7.0));
            System.out.println("Acceleration time from 0.0 to 14.0 = " + dp.getAccelerationTime(0.0, 14.0));
            System.out.println("Acceleration time from 7.0 to 14.0 = " + dp.getAccelerationTime(7.0, 14.0));
            System.out.println("Acceleration time from  0.0 to 7.0 = " + dp.getAccelerationTime(0.0, 7.0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class AccDecPoint {
        private double speed;
        private double accdec;

        public AccDecPoint(double speed, double accdec) {
            this.speed = speed;
            this.accdec = accdec;
        }

        public double getAccDec() {
            return this.accdec;
        }

        public double getSpeed() {
            return this.speed;
        }
    }

    private class Profile {
        private AccelerationProfile owner;
        private double[] accTime;
        private double[] accDistance;
        private double resolution = 0.1;
        private double maxSpeed = 0.0;
        private int points;

        public Profile(AccelerationProfile owner, double maxSpeed) {
            this.maxSpeed = maxSpeed;
            this.points = (int)(this.maxSpeed / this.resolution) + 1;
            this.owner = owner;
            this.accTime = new double[this.points];
            this.accDistance = new double[this.points];
            Driving driving = new Driving(this.owner, 0.001, 3);
            double speed = 0.0;
            double x = 0.0;
            double time = 0.0;
            while (speed <= this.maxSpeed) {
                int i;
                driving.initialize(time, new double[]{speed, x});
                double[] vx = driving.y(time += 0.001);
                speed = vx[0];
                double dx = vx[1] - x;
                x = vx[1];
                int n = i = this.getPoint(speed);
                this.accTime[n] = this.accTime[n] + 0.001;
                int n2 = i;
                this.accDistance[n2] = this.accDistance[n2] + dx;
            }
            int i = 0;
            while (i < this.points - 1) {
                int n = i + 1;
                this.accTime[n] = this.accTime[n] + this.accTime[i];
                int n3 = i + 1;
                this.accDistance[n3] = this.accDistance[n3] + this.accDistance[i];
                ++i;
            }
            if (debug) {
                i = 0;
                while (i < this.points) {
                    System.out.println("v=" + this.getSpeed(i) + ", [t,x]=[" + this.accTime[i] + "," + this.accDistance[i] + "]");
                    ++i;
                }
            }
        }

        private int getPoint(double speed) {
            int point = (int)(speed / this.maxSpeed * (double)this.points);
            return Math.min(this.points - 1, Math.max(point, 0));
        }

        private double getSpeed(int point) {
            return this.resolution * (double)point;
        }

        public double getAccelerationTime(double initialSpeed, double endSpeed) {
            return this.accTime[this.getPoint(endSpeed)] - this.accTime[this.getPoint(initialSpeed)];
        }

        public double getAccelerationDistance(double initialSpeed, double endSpeed) {
            return this.accDistance[this.getPoint(endSpeed)] - this.accDistance[this.getPoint(initialSpeed)];
        }

        private class Driving
        extends DifferentialEquation {
            private AccelerationProfile owner;

            public Driving(AccelerationProfile owner, double timeStep) {
                super(timeStep);
                this.owner = owner;
            }

            public Driving(AccelerationProfile owner, double timeStep, NumericalIntegrator integrator) {
                super(timeStep, integrator);
                this.owner = owner;
            }

            public Driving(AccelerationProfile owner, double timeStep, short integrationMethod) {
                super(timeStep, integrationMethod);
                this.owner = owner;
            }

            public double[] dy(double x, double[] y) {
                double[] dy = new double[]{this.owner.getAcceleration(y[0]), y[0]};
                return dy;
            }
        }
    }
}

