/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.traffic.vehicle;

import java.util.ArrayList;
import nl.tudelft.simulation.jstats.ode.DifferentialEquation;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;

public class DecelerationProfile {
    private ArrayList accdecList = new ArrayList();
    private double maxSpeed = 0.0;
    private boolean initialized = false;
    private Profile profile;
    protected static boolean debug = false;

    public DecelerationProfile(double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public void setDecelerationFromSpeed(double speed, double accdec) {
        this.accdecList.add(new AccDecPoint(speed, accdec));
        this.initialized = false;
    }

    public double getDeceleration(double speed) {
        double accdec = 0.0;
        int i = 0;
        while (i < this.accdecList.size()) {
            double adspeed = ((AccDecPoint)this.accdecList.get(i)).getSpeed();
            if (!(speed >= adspeed)) {
                return accdec;
            }
            accdec = ((AccDecPoint)this.accdecList.get(i)).getAccDec();
            ++i;
        }
        return accdec;
    }

    public void initializeProfile() {
        this.profile = new Profile(this, this.maxSpeed);
        this.initialized = true;
    }

    public double getBrakeTime(double initialSpeed, double endSpeed) {
        if (!this.initialized) {
            this.initializeProfile();
        }
        return this.profile.getBrakeTime(initialSpeed, endSpeed);
    }

    public double getBrakeDistance(double initialSpeed, double endSpeed) {
        if (!this.initialized) {
            this.initializeProfile();
        }
        return this.profile.getBrakeDistance(initialSpeed, endSpeed);
    }

    public static void main(String[] args) {
        try {
            DecelerationProfile dp = new DecelerationProfile(14.0);
            dp.setDecelerationFromSpeed(0.0, -1.0);
            dp.initializeProfile();
            System.out.println("Brake distance from 14.0 to 0.0 = " + dp.getBrakeDistance(14.0, 0.0));
            System.out.println("Brake distance from 14.0 to 7.0 = " + dp.getBrakeDistance(14.0, 7.0));
            System.out.println("Brake distance from  7.0 to 0.0 = " + dp.getBrakeDistance(7.0, 0.0));
            System.out.println("Brake time from 14.0 to 0.0 = " + dp.getBrakeTime(14.0, 0.0));
            System.out.println("Brake time from 14.0 to 7.0 = " + dp.getBrakeTime(14.0, 7.0));
            System.out.println("Brake time from  7.0 to 0.0 = " + dp.getBrakeTime(7.0, 0.0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class AccDecPoint {
        private double speed;
        private double accdec;

        public AccDecPoint(double speed, double accdec) {
            this.speed = speed;
            this.accdec = accdec;
        }

        public double getAccDec() {
            return this.accdec;
        }

        public double getSpeed() {
            return this.speed;
        }
    }

    private class Profile {
        private DecelerationProfile owner;
        private double[] brakeTime;
        private double[] brakeDistance;
        private double resolution = 0.1;
        private double maxSpeed = 0.0;
        private int points;

        public Profile(DecelerationProfile owner, double maxSpeed) {
            this.maxSpeed = maxSpeed;
            this.points = (int)(this.maxSpeed / this.resolution) + 1;
            this.owner = owner;
            this.brakeTime = new double[this.points];
            this.brakeDistance = new double[this.points];
            Driving driving = new Driving(this.owner, 0.001, 3);
            double speed = this.maxSpeed;
            double x = 0.0;
            double time = 0.0;
            while (speed > 0.0) {
                int i;
                driving.initialize(time, new double[]{speed, x});
                double[] vx = driving.y(time += 0.001);
                speed = vx[0];
                double dx = vx[1] - x;
                x = vx[1];
                int n = i = this.getPoint(speed);
                this.brakeTime[n] = this.brakeTime[n] + 0.001;
                int n2 = i;
                this.brakeDistance[n2] = this.brakeDistance[n2] + dx;
            }
            int i = 0;
            while (i < this.points - 1) {
                int n = i + 1;
                this.brakeTime[n] = this.brakeTime[n] + this.brakeTime[i];
                int n3 = i + 1;
                this.brakeDistance[n3] = this.brakeDistance[n3] + this.brakeDistance[i];
                ++i;
            }
            if (debug) {
                i = 0;
                while (i < this.points) {
                    System.out.println("v=" + this.getSpeed(i) + ", [t,x]=[" + this.brakeTime[i] + "," + this.brakeDistance[i] + "]");
                    ++i;
                }
            }
        }

        private int getPoint(double speed) {
            int point = (int)(speed / this.maxSpeed * (double)this.points);
            return Math.min(this.points - 1, Math.max(point, 0));
        }

        private double getSpeed(int point) {
            return this.resolution * (double)point;
        }

        public double getBrakeTime(double initialSpeed, double endSpeed) {
            return this.brakeTime[this.getPoint(initialSpeed)] - this.brakeTime[this.getPoint(endSpeed)];
        }

        public double getBrakeDistance(double initialSpeed, double endSpeed) {
            return this.brakeDistance[this.getPoint(initialSpeed)] - this.brakeDistance[this.getPoint(endSpeed)];
        }

        private class Driving
        extends DifferentialEquation {
            private DecelerationProfile owner;

            public Driving(DecelerationProfile owner, double timeStep) {
                super(timeStep);
                this.owner = owner;
            }

            public Driving(DecelerationProfile owner, double timeStep, NumericalIntegrator integrator) {
                super(timeStep, integrator);
                this.owner = owner;
            }

            public Driving(DecelerationProfile owner, double timeStep, short integrationMethod) {
                super(timeStep, integrationMethod);
                this.owner = owner;
            }

            public double[] dy(double x, double[] y) {
                double[] dy = new double[]{this.owner.getDeceleration(y[0]), y[0]};
                return dy;
            }

            public double[] y(double x) {
                double[] y = super.y(x);
                y[0] = Math.max(0.0, y[0]);
                return y;
            }
        }
    }
}

